/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import lombok.NonNull;
import org.iqnect.iqkit.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaUtils {
    private static final Logger log = LoggerFactory.getLogger(MediaUtils.class);
    private static final String MIME_TYPE_JPG = "image/jpeg";
    private static final String JPG = ".jpg";

    private MediaUtils() {
        throw new IllegalAccessError("No instances");
    }

    @WorkerThread
    @Nullable
    public static Uri saveGalleryImage(@NonNull Context context, @NonNull Bitmap source, @NonNull String albumName, long bitmapTimestamp) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (albumName == null) {
            throw new NullPointerException("albumName");
        }
        return MediaUtils.saveImage(context.getContentResolver(), source, null, null, albumName, bitmapTimestamp, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Nullable
    private static Uri saveImage(@NonNull ContentResolver cr, @NonNull Bitmap source, @Nullable String title, @Nullable String description, @NonNull String albumName, long bitmapTimestamp, int compression) {
        Uri url;
        block9: {
            if (cr == null) {
                throw new NullPointerException("cr");
            }
            if (source == null) {
                throw new NullPointerException("source");
            }
            if (albumName == null) {
                throw new NullPointerException("albumName");
            }
            url = null;
            try {
                File outputFile = MediaUtils.getGalleryFile(albumName, bitmapTimestamp);
                if (!outputFile.exists()) {
                    outputFile.createNewFile();
                }
                cr.delete(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "_data=?", new String[]{outputFile.getAbsolutePath()});
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(outputFile, false);
                    source.compress(Bitmap.CompressFormat.JPEG, compression, (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IoUtils.closeQuietly((Closeable)outputStream);
                ContentValues values = new ContentValues();
                values.put("title", title);
                values.put("description", description);
                values.put("mime_type", MIME_TYPE_JPG);
                values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
                values.put("_data", outputFile.getAbsolutePath());
                values.put("bucket_id", Integer.valueOf(albumName.hashCode()));
                values.put("bucket_display_name", albumName);
                url = cr.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                if (url != null) {
                    long id2 = ContentUris.parseId((Uri)url);
                    MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)1, null);
                }
            }
            catch (Exception e) {
                log.error("failed to insert image for url: {}", url, (Object)e);
                if (url == null) break block9;
                cr.delete(url, null, null);
                url = null;
            }
        }
        return url;
    }

    @NonNull
    private static File getGalleryFile(@NonNull String dirName, long bitmapTimestamp) {
        if (dirName == null) {
            throw new NullPointerException("dirName");
        }
        File outputFolder = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), dirName);
        return MediaUtils.getFile(outputFolder, bitmapTimestamp + JPG);
    }

    @NonNull
    private static File getFile(@NonNull File folder, @NonNull String name) {
        if (folder == null) {
            throw new NullPointerException("folder");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return new File(folder, name);
    }
}

