/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.content.Context;
import android.content.Intent;
import lombok.NonNull;
import org.iqnect.iqkit.ui.R;

public final class IntentUtils {
    private IntentUtils() {
        throw new IllegalAccessError("no instances");
    }

    public static void shareText(@NonNull Context context, @NonNull String text) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        Intent i = new Intent("android.intent.action.SEND");
        i.setType("text/plain");
        i.putExtra("android.intent.extra.TEXT", text);
        context.startActivity(Intent.createChooser((Intent)i, (CharSequence)context.getString(R.string.share_with)));
    }

    public static void shareAsEmail(@NonNull Context context, @NonNull String subject, @NonNull String text) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        Intent i = new Intent("android.intent.action.SEND");
        i.setType("text/html");
        i.putExtra("android.intent.extra.SUBJECT", subject);
        i.putExtra("android.intent.extra.TEXT", text);
        context.startActivity(Intent.createChooser((Intent)i, (CharSequence)context.getString(R.string.share_with)));
    }

    public static void shareIqnectContent(@NonNull Context context, @NonNull String url) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (url == null) {
            throw new NullPointerException("url");
        }
        String body = "Hey, check this out:\n\n" + url;
        IntentUtils.shareAsEmail(context, "Discover products with iQNECT", body);
    }
}

