/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import lombok.NonNull;
import org.iqnect.iqkit.http.SimpleHttpRequest;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;

public final class ConnectivityUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectivityUtils.class);
    private static final String IP2COUNTRY_URL = "http://ip2country.sourceforge.net/ip2c.php?format=JSON";
    private static final String IP_ADDRESS_OBJECT = "ip";

    private ConnectivityUtils() {
        throw new AssertionError((Object)"No instances.");
    }

    public static boolean hasConnection(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Context appContext = context.getApplicationContext();
        ConnectivityManager cm = (ConnectivityManager)appContext.getSystemService("connectivity");
        NetworkInfo wifiNetwork = cm.getNetworkInfo(1);
        if (wifiNetwork != null && wifiNetwork.isConnected()) {
            return true;
        }
        NetworkInfo mobileNetwork = cm.getNetworkInfo(0);
        if (mobileNetwork != null && mobileNetwork.isConnected()) {
            return true;
        }
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public static Observable<String> getPublicIpAddress() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(Subscriber<? super String> subscriber) {
                try {
                    SimpleHttpRequest req = new SimpleHttpRequest(ConnectivityUtils.IP2COUNTRY_URL);
                    JSONObject jsonObject = req.preparePost().sendAndReadJSON();
                    subscriber.onNext((Object)jsonObject.getString(ConnectivityUtils.IP_ADDRESS_OBJECT));
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }
}

