/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.app.Activity;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import butterknife.internal.Finder;
import butterknife.internal.ViewBinder;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.iqnect.iqkit.ui.util.ButterKnifeUtil$$Lambda$1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ButterKnifeUtil {
    private static final Logger log = LoggerFactory.getLogger(ButterKnifeUtil.class);
    @NonNull
    private static Method sFindViewBinderForClassMethod;

    private ButterKnifeUtil() {
    }

    @NonNull
    public static Unbinder bind(@NonNull Activity target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        Unbinder unbinder = ButterKnife.bind((Activity)target);
        return ButterKnifeUtil.callSuperViewBinder(unbinder, Finder.ACTIVITY, target, target);
    }

    @NonNull
    public static Unbinder bind(@NonNull View target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        Unbinder unbinder = ButterKnife.bind((View)target);
        return ButterKnifeUtil.callSuperViewBinder(unbinder, Finder.VIEW, target, target);
    }

    @NonNull
    public static Unbinder bind(@NonNull Object target, @NonNull View source) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        Unbinder unbinder = ButterKnife.bind((Object)target, (View)source);
        return ButterKnifeUtil.callSuperViewBinder(unbinder, Finder.VIEW, target, source);
    }

    @NonNull
    private static Unbinder callSuperViewBinder(@NonNull Unbinder unbinder, @NonNull Finder finder, @NonNull Object target, @NonNull Object source) {
        if (unbinder == null) {
            throw new NullPointerException("unbinder");
        }
        if (finder == null) {
            throw new NullPointerException("finder");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!unbinder.getClass().getName().contains("iqkit")) {
            try {
                ViewBinder<Object> viewBinder = ButterKnifeUtil.superViewBinder(target.getClass());
                Unbinder unbinder2 = viewBinder.bind(finder, target, source);
                return ButterKnifeUtil$$Lambda$1.lambdaFactory$(unbinder, unbinder2);
            }
            catch (Throwable t) {
                log.warn("Failed to invoke super view binder for {}", target);
            }
        }
        return unbinder;
    }

    private static ViewBinder<Object> superViewBinder(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        String clazzName = clazz.getName();
        while (!(clazzName.contains("iqkit") || clazzName.startsWith("android.") || clazzName.startsWith("java."))) {
            clazz = clazz.getSuperclass();
            clazzName = clazz.getName();
        }
        return (ViewBinder)sFindViewBinderForClassMethod.invoke(null, clazz);
    }

    static /* synthetic */ void lambda$callSuperViewBinder$0(@NonNull Unbinder unbinder, Unbinder unbinder2) {
        unbinder.unbind();
        unbinder2.unbind();
    }

    static {
        try {
            sFindViewBinderForClassMethod = ButterKnife.class.getDeclaredMethod("findViewBinderForClass", Class.class);
            sFindViewBinderForClassMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            log.error("error occurred", (Throwable)e);
        }
    }
}

