/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.opengl;

import android.opengl.GLES20;
import android.support.annotation.NonNull;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.iqnect.iqkit.ui.opengl.Shape;

public class Oval
extends Shape {
    private static final String VERTEX_SHADER_CODE = "uniform mat4 uMVPMatrix;attribute vec4 vPosition;void main() {  gl_Position = uMVPMatrix * vPosition;}";
    private static final String FRAGMENT_SHADER_CODE = "precision mediump float;uniform vec4 vColor;void main() {  gl_FragColor = vColor;}";
    private static final int COORDS_PER_VERTEX = 2;
    private static final int VERTEX_STRIDE = 12;

    @NonNull
    private static FloatBuffer createVertexBuffer(float width, float height, float depth) {
        float[] vertices = new float[1092];
        vertices[0] = 0.0f;
        vertices[1] = 0.0f;
        vertices[2] = 0.0f;
        for (int i = 1; i < 364; ++i) {
            vertices[i * 3] = (float)Math.cos(Math.PI / 180 * (double)i) * (width / 2.0f);
            vertices[i * 3 + 1] = (float)Math.sin(Math.PI / 180 * (double)i) * (height / 2.0f);
            vertices[i * 3 + 2] = depth;
        }
        return Shape.generateFloatBuffer(vertices);
    }

    private static void preDraw(int program) {
        GLES20.glUseProgram((int)program);
    }

    private void render(@NonNull float[] mvpMatrix, int program, @NonNull FloatBuffer vertexBuffer) {
        float[] objectMatrix = this.getObjectMatrix(mvpMatrix);
        int positionHandle = GLES20.glGetAttribLocation((int)program, (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20.glVertexAttribPointer((int)positionHandle, (int)2, (int)5126, (boolean)false, (int)12, (Buffer)vertexBuffer);
        int colorHandle = GLES20.glGetUniformLocation((int)program, (String)"vColor");
        GLES20.glUniform4fv((int)colorHandle, (int)1, (float[])this.getColorMatrix(), (int)0);
        int mvpMatrixHandle = GLES20.glGetUniformLocation((int)program, (String)"uMVPMatrix");
        GLES20.glUniformMatrix4fv((int)mvpMatrixHandle, (int)1, (boolean)false, (float[])objectMatrix, (int)0);
        GLES20.glDrawArrays((int)6, (int)0, (int)364);
        GLES20.glDisableVertexAttribArray((int)positionHandle);
    }

    private static int createProgram() {
        return Oval.createProgram(VERTEX_SHADER_CODE, FRAGMENT_SHADER_CODE, new Shape.Attribute[0]);
    }

    static /* synthetic */ int access$000() {
        return Oval.createProgram();
    }

    public static class OvalHelper
    extends Shape.Helper<Oval> {
        @NonNull
        private final FloatBuffer mVertexBuffer;
        private final int mProgram = Oval.access$000();

        public OvalHelper(float width, float height, float depth) {
            this.mVertexBuffer = Oval.createVertexBuffer(width, height, depth);
        }

        @Override
        public void preDraw() {
            Oval.preDraw(this.mProgram);
        }

        @Override
        public void render(@NonNull Oval oval, @NonNull float[] mvpMatrix) {
            oval.render(mvpMatrix, this.mProgram, this.mVertexBuffer);
        }

        @Override
        public void postDraw() {
        }
    }
}

