/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.injection;

import android.app.Activity;
import android.content.Context;
import dagger.Module;
import dagger.Provides;
import lombok.NonNull;
import org.iqnect.iqkit.ui.ErrorHandler;
import org.iqnect.iqkit.ui.app.Alerts;
import org.iqnect.iqkit.ui.camera.ImageChooser;
import org.iqnect.iqkit.ui.camera.SystemImageChooser;
import org.iqnect.iqkit.ui.injection.ActivityModule$$Lambda$1;
import org.iqnect.iqkit.ui.injection.ActivityScope;

@Module
public class ActivityModule {
    private Activity mActivity;

    public ActivityModule(Activity activity) {
        this.mActivity = activity;
    }

    @Provides
    @ActivityScope
    Activity provideActivity() {
        return this.mActivity;
    }

    @Provides
    @ActivityScope
    Context provideContext() {
        return this.mActivity.getApplicationContext();
    }

    @Provides
    @ActivityScope
    ErrorHandler provideErrorHandler(@NonNull Alerts alerts) {
        if (alerts == null) {
            throw new NullPointerException("alerts");
        }
        Alerts alerts2 = alerts;
        alerts2.getClass();
        return ActivityModule$$Lambda$1.lambdaFactory$(alerts2);
    }

    @Provides
    @ActivityScope
    ImageChooser provideImageChooser(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return new SystemImageChooser(context);
    }
}

