/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Patterns;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareHashtag;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.widget.ShareDialog;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.iqnect.iqkit.ui.injection.UIComponentFactory;
import org.iqnect.iqkit.ui.uri.Instruction;
import org.iqnect.iqkit.ui.uri.InstructionHandler;
import org.iqnect.iqkit.ui.uri.InstructionHandlerCallback;
import org.iqnect.iqkit.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookShareInstructionHandler
implements InstructionHandler {
    private static final Logger log = LoggerFactory.getLogger(FacebookShareInstructionHandler.class);
    @NonNull
    private final Gson mGson;

    public FacebookShareInstructionHandler(@NonNull Gson gson) {
        this.mGson = gson;
    }

    @Override
    public boolean canHandleInstruction(@NonNull Instruction instruction) {
        return "facebook_share".equals(instruction.getMethod()) && (FacebookShareInstructionHandler.isValidUri(instruction.getParam()) || FacebookShareInstructionHandler.isJsonObject(instruction.getParam()));
    }

    @Override
    @Nullable
    public Intent getIntent(@NonNull Context context, @NonNull Instruction instruction) {
        return null;
    }

    @Override
    public void handleInstruction(@NonNull Context context, @NonNull Instruction instruction, @NonNull InstructionHandlerCallback callback) {
        if (!(context instanceof Activity)) {
            log.warn("Attempted Facebook share {} with non-Activity context of {}", (Object)instruction, (Object)context);
            callback.onCancel();
            return;
        }
        Activity activity = (Activity)context;
        if (FacebookShareInstructionHandler.isJsonObject(instruction.getParam())) {
            try {
                ShareObject shareObject = (ShareObject)this.mGson.fromJson(instruction.getParam(), ShareObject.class);
                this.showShareDialog(activity, shareObject, callback);
            }
            catch (Throwable t) {
                log.warn("error while parsing facebook json object {}", (Object)instruction.getParam(), (Object)t);
                callback.onCancel();
            }
        } else {
            ShareObject shareObject = new ShareObject();
            shareObject.contentUrl = Uri.parse((String)instruction.getParam());
            this.showShareDialog(activity, shareObject, callback);
        }
    }

    private void showShareDialog(@NonNull Activity activity, @NonNull ShareObject shareObject, final @NonNull InstructionHandlerCallback callback) {
        log.debug("showing share dialog");
        CallbackManager callbackManager = UIComponentFactory.getInstance((Context)activity).getFacebookCallbackManager();
        ShareDialog shareDialog = new ShareDialog(activity);
        ShareLinkContent.Builder builder = new ShareLinkContent.Builder();
        FacebookShareInstructionHandler.applyShareContentValues((ShareContent.Builder)builder, shareObject);
        ShareLinkContent content = builder.setContentDescription(shareObject.contentDescription).setContentTitle(shareObject.contentTitle).setImageUrl(shareObject.imageUrl).setQuote(shareObject.quote).build();
        shareDialog.registerCallback(callbackManager, (FacebookCallback)new FacebookCallback<Sharer.Result>(){

            public void onSuccess(@NonNull Sharer.Result result) {
                log.debug("success");
                if (result.getPostId() != null) {
                    callback.onSuccess();
                } else {
                    log.debug("no post id, sending onCancel to instruction handler callback");
                    callback.onCancel();
                }
            }

            public void onCancel() {
                log.debug("cancel");
                callback.onCancel();
            }

            public void onError(FacebookException e) {
                log.error("error", (Throwable)e);
                callback.onError((Exception)e);
            }
        });
        shareDialog.show((Object)content);
    }

    private static void applyShareContentValues(@NonNull ShareContent.Builder builder, @NonNull ShareObject shareObject) {
        builder.setContentUrl(shareObject.contentUrl).setPeopleIds(shareObject.peopleIds).setPlaceId(shareObject.placeId).setRef(shareObject.ref);
        if (!Objects.isNullOrEmpty((CharSequence)shareObject.hashTag)) {
            builder.setShareHashtag(new ShareHashtag.Builder().setHashtag(shareObject.hashTag).build());
        }
    }

    private static boolean isValidUri(@Nullable CharSequence uriString) {
        return !Objects.isNullOrEmpty((CharSequence)uriString) && Patterns.WEB_URL.matcher(uriString).matches();
    }

    private static boolean isJsonObject(@Nullable CharSequence str) {
        return !Objects.isNullOrEmpty((CharSequence)str) && str.charAt(0) == '{';
    }

    private static class ShareObject {
        @SerializedName(value="contentUrl")
        @Nullable
        private Uri contentUrl;
        @SerializedName(value="contentTitle")
        @Nullable
        private String contentTitle;
        @SerializedName(value="contentDescription")
        @Nullable
        private String contentDescription;
        @SerializedName(value="imageURL")
        @Nullable
        private Uri imageUrl;
        @SerializedName(value="quote")
        @Nullable
        private String quote;
        @SerializedName(value="peopleIDs")
        @Nullable
        private List<String> peopleIds;
        @SerializedName(value="placeID")
        @Nullable
        private String placeId;
        @SerializedName(value="ref")
        @Nullable
        private String ref;
        @SerializedName(value="hashtag")
        @Nullable
        private String hashTag;

        private ShareObject() {
        }
    }
}

