/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.camera.ImageChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemImageChooser
implements ImageChooser {
    private static final Logger log = LoggerFactory.getLogger(SystemImageChooser.class);
    private static final String INTENT_TYPE_FILTER_IMAGES = "image/*";
    @NonNull
    private final Context mContext;
    @NonNull
    private final List<ResolveInfo> mActivities;
    private File mTempImage;

    @Inject
    public SystemImageChooser(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.mContext = context;
        this.mActivities = context.getPackageManager().queryIntentActivities(this.intent(), 0);
        try {
            File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
            this.mTempImage = File.createTempFile("iqnect-camera", "jpg", dir);
            this.mTempImage.delete();
            log.debug("temp image: {}", (Object)this.mTempImage);
        }
        catch (IOException e) {
            log.error("error creating temporary image file", (Throwable)e);
        }
    }

    @Override
    public boolean isAvailable() {
        return !this.mActivities.isEmpty();
    }

    @Override
    public void startForResult(@NonNull Activity activity, int requestCode) {
        if (activity == null) {
            throw new NullPointerException("activity");
        }
        if (this.mTempImage != null) {
            this.mTempImage.delete();
        }
        if (this.mActivities.size() > 1) {
            activity.startActivityForResult(this.chooser(), requestCode);
        } else if (this.mActivities.size() == 1) {
            activity.startActivityForResult(this.intent(), requestCode);
        }
    }

    @Override
    public void startForResult(@NonNull Fragment fragment, int requestCode) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        if (this.mTempImage != null) {
            this.mTempImage.delete();
        }
        if (this.mActivities.size() > 1) {
            fragment.startActivityForResult(this.chooser(), requestCode);
        } else if (this.mActivities.size() == 1) {
            fragment.startActivityForResult(this.intent(), requestCode);
        }
    }

    @Override
    public Uri getImageUri(Intent data) {
        if (data != null && data.getData() != null) {
            return data.getData();
        }
        if (this.mTempImage != null && this.mTempImage.exists()) {
            return Uri.fromFile((File)this.mTempImage);
        }
        return null;
    }

    @NonNull
    private Intent chooser() {
        return Intent.createChooser((Intent)this.intent(), (CharSequence)this.mContext.getResources().getString(R.string.choose_image));
    }

    @NonNull
    private Intent intent() {
        Intent galleryIntent = new Intent("android.intent.action.OPEN_DOCUMENT", null);
        galleryIntent.setType(INTENT_TYPE_FILTER_IMAGES);
        galleryIntent.addCategory("android.intent.category.OPENABLE");
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        Intent[] intentArray = new Intent[]{cameraIntent};
        if (this.mTempImage != null) {
            cameraIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.mTempImage));
            log.debug("extra output: {}", (Object)Uri.fromFile((File)this.mTempImage));
        }
        Intent chooser = new Intent("android.intent.action.CHOOSER");
        chooser.putExtra("android.intent.extra.INTENT", (Parcelable)galleryIntent);
        chooser.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])intentArray);
        return chooser;
    }
}

