/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;
import com.squareup.otto.Bus;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.camera.CameraOverlayView;
import org.iqnect.iqkit.ui.camera.CameraView$$Lambda$1;
import org.iqnect.iqkit.ui.camera.CameraView$$Lambda$2;
import org.iqnect.iqkit.ui.camera.CameraView$$Lambda$3;
import org.iqnect.iqkit.ui.camera.CameraView$$Lambda$4;
import org.iqnect.iqkit.ui.camera.ScanResult;
import org.iqnect.iqkit.ui.camera.Scanner;
import org.iqnect.iqkit.ui.util.ActivityUtils;
import org.iqnect.iqkit.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CameraView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private static final Logger log = LoggerFactory.getLogger(CameraView.class);
    private static final int MAX_LARGER_DIMENSION = 1920;
    private static final int MAX_SMALLER_DIMENSION = 1080;
    private static final int SCAN_INTERVAL_MILLIS = 1000;
    protected static final int INVALID = -1;
    private static final String KEY_SUPER_STATE = "superState";
    @Inject
    Bus mBus;
    @Nullable
    private CameraOverlayView mOverlayView;
    @Nullable
    private final Scanner mScanner;
    @Nullable
    private Camera mCamera;
    @Nullable
    private OnScanResultListener mOnScanResultListener;
    @Nullable
    private PreviewCallback mPreviewCallback;
    @Nullable
    private Camera.Size mPreviewSize;
    private long mLastScanTime = System.currentTimeMillis();
    private int mHeight;
    private int mWidth;
    private int mDisplayOrientation = -1;
    private int mCameraOrientation = -1;
    private boolean mResumed;
    private boolean mPreviewStarted;
    private boolean dispatchQrCode = true;
    private static final float FOCUS_SIZE = 150.0f;
    Scanner.OnScanListener mBarCodeScanListener = CameraView$$Lambda$1.lambdaFactory$(this);

    public CameraView(Context context) {
        this(context, null);
    }

    public CameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.mScanner = new Scanner();
        } else {
            this.mScanner = null;
            this.setBackgroundColor(-11184811);
        }
        BaseActivity activity = (BaseActivity)ActivityUtils.getActivity(context);
        if (activity != null) {
            activity.getActivityComponent().inject(this);
        }
    }

    public void onTapToFocus(MotionEvent event) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        int maxNumFocusAreas = parameters.getMaxNumFocusAreas();
        int maxNumMeteringAreas = parameters.getMaxNumMeteringAreas();
        if (maxNumFocusAreas <= 0 && maxNumMeteringAreas <= 0) {
            return;
        }
        this.mCamera.cancelAutoFocus();
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        float eventX = MathUtils.clamp((float)event.getRawX(), (float)0.0f, (float)viewWidth);
        float eventY = MathUtils.clamp((float)event.getRawY(), (float)0.0f, (float)viewHeight);
        Rect tapAreaRect = this.calcTapArea(viewWidth, viewHeight, eventX, eventY);
        List<Camera.Area> tapArea = Collections.singletonList(new Camera.Area(tapAreaRect, 1000));
        if (maxNumMeteringAreas > 0) {
            parameters.setMeteringAreas(tapArea);
        }
        if (maxNumFocusAreas > 0) {
            parameters.setFocusAreas(tapArea);
            parameters.setFocusMode("auto");
        }
        try {
            this.mCamera.setParameters(parameters);
        }
        catch (Throwable t) {
            log.warn("Failed to update camera parameters {}", (Object)parameters, (Object)t);
        }
        if (maxNumFocusAreas > 0) {
            this.mCamera.autoFocus(CameraView$$Lambda$2.lambdaFactory$(this));
        }
    }

    @NonNull
    private Rect calcTapArea(float viewWidth, float viewHeight, float x, float y) {
        float normX = x / viewWidth * 2000.0f - 1000.0f;
        float normY = y / viewHeight * 2000.0f - 1000.0f;
        float left = MathUtils.clamp((float)(normX - 75.0f), (float)-1000.0f, (float)1000.0f);
        float right = MathUtils.clamp((float)(left + 150.0f), (float)-1000.0f, (float)1000.0f);
        float top = MathUtils.clamp((float)(normY - 75.0f), (float)-1000.0f, (float)1000.0f);
        float bottom = MathUtils.clamp((float)(top + 150.0f), (float)-1000.0f, (float)1000.0f);
        log.debug("calTapArea: adjusting for orientation {}", (Object)this.mDisplayOrientation);
        switch (this.mDisplayOrientation) {
            case 0: {
                break;
            }
            case 90: {
                float temp = left;
                left = top;
                top = -right;
                right = bottom;
                bottom = -temp;
                break;
            }
            case 180: {
                float temp = left;
                left = -right;
                right = -temp;
                temp = top;
                top = -bottom;
                bottom = -temp;
                break;
            }
            case 270: {
                float temp = left;
                left = -bottom;
                bottom = right;
                right = -top;
                top = temp;
            }
        }
        log.debug("\ncalcTapArea: width/height {} {} x/y: {} {} \nlrtb: {} {} {} {}\n %: {} {} {} {}", new Object[]{Float.valueOf(viewWidth), Float.valueOf(viewHeight), Float.valueOf(x), Float.valueOf(y), Float.valueOf(left), Float.valueOf(right), Float.valueOf(top), Float.valueOf(bottom), CameraView.pp(left), CameraView.pp(right), CameraView.pp(top), CameraView.pp(bottom)});
        return new Rect((int)left, (int)top, (int)right, (int)bottom);
    }

    private static int pp(float i) {
        return ((int)i + 1000) * 100 / 2000;
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, super.onSaveInstanceState());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            super.onRestoreInstanceState(bundle.getParcelable(KEY_SUPER_STATE));
        }
        this.updateScanner();
    }

    public void onResume(int activityRotation) {
        this.mResumed = true;
        this.attachCamera(activityRotation);
        this.startPreview();
        if (this.isAvailable()) {
            this.setSurfaceToCameraPreviewTexture(this.getSurfaceTexture());
        } else {
            this.setSurfaceTextureListener(this);
        }
        if (this.mOverlayView != null) {
            this.mOverlayView.onResume();
        }
        this.updateScanner();
    }

    public void onPause() {
        this.mResumed = false;
        this.stopPreview();
        if (this.mOverlayView != null) {
            this.mOverlayView.onPause();
        }
        this.updateScanner();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != this.mWidth || h != this.mHeight) {
            this.mWidth = w;
            this.mHeight = h;
            this.startPreview();
        }
    }

    private void attachCamera(int activityRotation) {
        if (this.mCamera == null) {
            int cameraId = -1;
            try {
                cameraId = this.getCameraId();
                if (cameraId >= 0) {
                    log.debug("Open cameraId {} ...", (Object)cameraId);
                    this.mCamera = Camera.open((int)cameraId);
                    this.setCameraDisplayOrientation(cameraId, activityRotation);
                } else {
                    log.error("failed to find an available camera");
                    this.mBus.post((Object)new AttachError(cameraId, null));
                }
            }
            catch (Throwable t) {
                log.error("exception initialising camera", t);
                this.mBus.post((Object)new AttachError(cameraId, t));
            }
        }
    }

    private int getCameraId() {
        int count = Camera.getNumberOfCameras();
        int result = -1;
        if (count > 0) {
            result = 0;
            Camera.CameraInfo info = new Camera.CameraInfo();
            for (int i = 0; i < count; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing != 0) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    private void setCameraDisplayOrientation(int cameraId, int activityRotation) {
        if (this.mCamera != null) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            int degrees = 0;
            Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
            switch (activityRotation) {
                case 0: {
                    degrees = 0;
                    break;
                }
                case 1: {
                    degrees = 90;
                    break;
                }
                case 2: {
                    degrees = 180;
                    break;
                }
                case 3: {
                    degrees = 270;
                }
            }
            this.mDisplayOrientation = (info.orientation - degrees + 360) % 360;
            this.mCameraOrientation = info.orientation;
            this.mCamera.setDisplayOrientation(this.mDisplayOrientation);
        }
    }

    private void stopPreview() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mPreviewStarted = false;
        }
    }

    private void startPreview() {
        if (this.mCamera == null || this.mPreviewStarted) {
            return;
        }
        this.mPreviewSize = this.getBestAspectPreviewSize(this.mDisplayOrientation, this.mCamera.getParameters());
        if (this.mPreviewSize == null) {
            return;
        }
        log.debug("Start preview using preview size of ({},{})", (Object)this.mPreviewSize.width, (Object)this.mPreviewSize.height);
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setPreviewSize(this.mPreviewSize.width, this.mPreviewSize.height);
        List fpsRanges = parameters.getSupportedPreviewFpsRange();
        int[] desiredRange = (int[])fpsRanges.get(fpsRanges.size() - 1);
        parameters.setPreviewFpsRange(desiredRange[0], desiredRange[1]);
        this.mCamera.setParameters(parameters);
        this.mCamera.setPreviewCallback(CameraView$$Lambda$3.lambdaFactory$(this));
        this.mCamera.startPreview();
        this.mPreviewStarted = true;
    }

    @Nullable
    private Camera.Size getBestAspectPreviewSize(int displayOrientation, @NonNull Camera.Parameters parameters) {
        int maxHeight;
        int maxWidth;
        float targetRatio;
        if (this.mWidth <= 0 || this.mHeight <= 0) {
            return null;
        }
        if (displayOrientation == 90 || displayOrientation == 270) {
            targetRatio = (float)this.mHeight / (float)this.mWidth;
            maxWidth = 1920;
            maxHeight = 1080;
        } else {
            targetRatio = (float)this.mWidth / (float)this.mHeight;
            maxWidth = 1080;
            maxHeight = 1920;
        }
        List sizes = parameters.getSupportedPreviewSizes();
        Collections.sort(sizes, Collections.reverseOrder(CameraView$$Lambda$4.lambdaFactory$()));
        Camera.Size optimalSize = null;
        float minDiff = Float.MAX_VALUE;
        for (Camera.Size size : sizes) {
            if (size.width > maxWidth || size.height > maxHeight) {
                log.debug("skipping size ({},{}), too large", (Object)size.width, (Object)size.height);
                continue;
            }
            float ratio = (float)size.width / (float)size.height;
            float offset = Math.abs(ratio - targetRatio);
            if (offset <= 0.0f) {
                log.debug("perfect size: ({},{}) for ratio {}, orientation {}", new Object[]{size.width, size.height, Float.valueOf(targetRatio), displayOrientation});
                return size;
            }
            if (!(offset < minDiff)) continue;
            optimalSize = size;
            minDiff = offset;
        }
        if (optimalSize != null) {
            log.debug("optimal size: ({},{}) for ratio {}, orientation {}", new Object[]{optimalSize.width, optimalSize.height, Float.valueOf(targetRatio), displayOrientation});
        }
        return optimalSize;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.setSurfaceToCameraPreviewTexture(surface);
    }

    private void setSurfaceToCameraPreviewTexture(SurfaceTexture surface) {
        if (this.mCamera != null) {
            try {
                log.debug("Attaching camera to surface");
                this.mCamera.setPreviewTexture(surface);
                this.setContinuousFocusMode(this.mCamera);
            }
            catch (IOException e) {
                log.error("failed to attach camera", (Throwable)e);
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastScanTime > 1000L) {
            log.trace("sending preview frame to scanner");
            this.mLastScanTime = currentTime;
            Camera.Size size = camera.getParameters().getPreviewSize();
            if (this.mScanner != null && this.dispatchQrCode) {
                this.mScanner.scan(data, size.width, size.height);
            }
        }
        if (this.mPreviewCallback != null) {
            this.mPreviewCallback.onPreviewFrame(data, camera);
        }
    }

    public boolean supportsZoom() {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            return parameters.isZoomSupported();
        }
        return false;
    }

    public int getMaxZoom() {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            return parameters.getMaxZoom();
        }
        return -1;
    }

    public int getZoom() {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            return parameters.getZoom();
        }
        return -1;
    }

    public void setZoom(int level) {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            parameters.setZoom(level);
            this.mCamera.setParameters(parameters);
        }
    }

    public void setContinuousFocusMode(@NonNull Camera camera) {
        Camera.Parameters params = camera.getParameters();
        List supportedFocusModes = params.getSupportedFocusModes();
        if (supportedFocusModes == null || supportedFocusModes.size() <= 0) {
            log.debug("continuous focus not available");
            return;
        }
        if (supportedFocusModes.contains("continuous-picture")) {
            log.debug("continuous picture focus");
            params.setFocusMode("continuous-picture");
        } else if (supportedFocusModes.contains("continuous-video")) {
            log.debug("continuous video focus");
            params.setFocusMode("continuous-video");
        } else if (supportedFocusModes.contains("auto")) {
            log.debug("manual picture focus");
            params.setFocusMode("auto");
        }
        camera.setParameters(params);
    }

    @Nullable
    public String cycleFlashMode() {
        if (this.mCamera == null) {
            log.debug("camera null!");
            return null;
        }
        String flashMode = this.getFlashMode();
        List<String> flashModes = this.getDesiredFlashModes(this.mCamera);
        if (flashModes.size() < 2) {
            return null;
        }
        int index = flashMode == null ? 0 : flashModes.indexOf(flashMode);
        index = (index + 1) % flashModes.size();
        flashMode = flashModes.get(index);
        Camera.Parameters params = this.mCamera.getParameters();
        params.setFlashMode(flashMode);
        this.mCamera.setParameters(params);
        log.info("new flash mode: {}", (Object)flashMode);
        return flashMode;
    }

    @Nullable
    public String getFlashMode() {
        return this.mCamera != null ? this.mCamera.getParameters().getFlashMode() : null;
    }

    public void setFlashMode(String mode) {
        if (this.mCamera != null) {
            Camera.Parameters params = this.mCamera.getParameters();
            params.setFlashMode(mode);
            this.mCamera.setParameters(params);
        }
    }

    public boolean isFlashSupported() {
        if (this.mCamera != null) {
            List<String> flashModes = this.getDesiredFlashModes(this.mCamera);
            return flashModes.size() >= 2;
        }
        return false;
    }

    @NonNull
    @SuppressLint(value={"DefaultLocale"})
    private List<String> getDesiredFlashModes(@NonNull Camera camera) {
        Camera.Parameters params = camera.getParameters();
        List flashModes = params.getSupportedFlashModes();
        log.info("supported flash modes: {}", (Object)flashModes);
        if (flashModes == null || flashModes.size() == 0) {
            return Collections.emptyList();
        }
        Iterator iterator = flashModes.iterator();
        while (iterator.hasNext()) {
            String mode = ((String)iterator.next()).toLowerCase();
            if (!mode.equalsIgnoreCase("auto") && !mode.equalsIgnoreCase("on") && !mode.equalsIgnoreCase("red-eye")) continue;
            iterator.remove();
        }
        log.info("desired flash modes: {}", (Object)flashModes);
        return flashModes;
    }

    private void updateScanner() {
        if (this.mScanner != null) {
            this.mScanner.setEnabled(this.mResumed);
            if (this.mResumed) {
                this.mScanner.setScanListener(this.mBarCodeScanListener);
            } else {
                this.mScanner.setScanListener(null);
            }
        }
    }

    private void scanPreviewFrame(@NonNull byte[] data, @NonNull Camera camera) {
        Camera.Size size = camera.getParameters().getPreviewSize();
        if (this.mScanner != null) {
            this.mScanner.scan(data, size.width, size.height);
        }
    }

    private void dispatchScanResults(@NonNull List<ScanResult> scanResults) {
        if (this.mOnScanResultListener != null) {
            this.mOnScanResultListener.onScanResult(scanResults);
        }
    }

    public void pauseDispatchQrCode() {
        this.dispatchQrCode = false;
    }

    public void resumeDispatchQrCode() {
        this.dispatchQrCode = true;
    }

    @Nullable
    public CameraOverlayView getOverlayView() {
        return this.mOverlayView;
    }

    public void setOverlayView(@Nullable CameraOverlayView mOverlayView) {
        this.mOverlayView = mOverlayView;
    }

    @Nullable
    public OnScanResultListener getOnScanResultListener() {
        return this.mOnScanResultListener;
    }

    public void setOnScanResultListener(@Nullable OnScanResultListener mOnScanResultListener) {
        this.mOnScanResultListener = mOnScanResultListener;
    }

    @Nullable
    public PreviewCallback getPreviewCallback() {
        return this.mPreviewCallback;
    }

    public void setPreviewCallback(@Nullable PreviewCallback mPreviewCallback) {
        this.mPreviewCallback = mPreviewCallback;
    }

    public int getCameraOrientation() {
        return this.mCameraOrientation;
    }

    /* synthetic */ void lambda$new$2(List results) {
        if (!results.isEmpty()) {
            this.dispatchScanResults(results);
        }
    }

    static /* synthetic */ int lambda$getBestAspectPreviewSize$1(Camera.Size lhs, Camera.Size rhs) {
        int left = lhs.width * lhs.height;
        int right = rhs.width * rhs.height;
        if (left < right) {
            return -1;
        }
        if (left > right) {
            return 1;
        }
        return 0;
    }

    /* synthetic */ void lambda$onTapToFocus$0(boolean success, Camera camera) {
        this.setContinuousFocusMode(camera);
    }

    public static interface OnScanResultListener {
        public void onScanResult(@NonNull List<ScanResult> var1);
    }

    public static class AttachError {
        @Nullable
        private final Integer mCameraId;
        @Nullable
        private final Throwable mThrowable;

        private AttachError(@Nullable Integer cameraId, @Nullable Throwable throwable) {
            this.mCameraId = cameraId;
            this.mThrowable = throwable;
        }

        @Nullable
        public Integer getCameraId() {
            return this.mCameraId;
        }

        @Nullable
        public Throwable getThrowable() {
            return this.mThrowable;
        }
    }

    public static interface PreviewCallback {
        public void onPreviewFrame(@NonNull byte[] var1, @NonNull Camera var2);
    }
}

