/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.content.Context;
import android.widget.Toast;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.ui.Errors;

public class Toasts {
    @NonNull
    private final Context mContext;
    @NonNull
    private final Errors mErrors;

    @Inject
    public Toasts(@NonNull Context context, @NonNull Errors errors) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (errors == null) {
            throw new NullPointerException("errors");
        }
        this.mContext = context.getApplicationContext();
        this.mErrors = errors;
    }

    public void showToast(@NonNull CharSequence msg) {
        if (msg == null) {
            throw new NullPointerException("msg");
        }
        Toast.makeText((Context)this.mContext, (CharSequence)msg, (int)0).show();
    }

    public void showToast(int stringResId) {
        Toast.makeText((Context)this.mContext, (int)stringResId, (int)0).show();
    }

    public void showToast(@NonNull Throwable e) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        Toast.makeText((Context)this.mContext, (CharSequence)this.mErrors.getMessage(e), (int)0).show();
    }
}

