/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import butterknife.BindView;
import butterknife.OnClick;
import com.getbase.floatingactionbutton.FloatingActionButton;
import com.getbase.floatingactionbutton.FloatingActionsMenu;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.api.AccountService;
import org.iqnect.iqkit.model.SearchResult;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.app.BaseFragment;
import org.iqnect.iqkit.ui.app.ExtendedFragmentManager;
import org.iqnect.iqkit.ui.app.NotificationDialogFragment;
import org.iqnect.iqkit.ui.app.SearchResultActivity;
import org.iqnect.iqkit.ui.app.SearchResultFragment$$Lambda$1;
import org.iqnect.iqkit.ui.app.SearchResultFragment$$Lambda$2;
import org.iqnect.iqkit.ui.app.SearchResultFragment$2$$Lambda$1;
import org.iqnect.iqkit.ui.util.DeviceUtils;
import org.iqnect.iqkit.ui.util.IntentUtils;
import org.iqnect.iqkit.ui.webkit.IqWebChromeClient;
import org.iqnect.iqkit.ui.webkit.IqWebView;
import org.iqnect.iqkit.ui.webkit.IqWebViewClient;
import org.iqnect.iqkit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultFragment
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(SearchResultFragment.class);
    private static final Type PAYLOAD_MAP_TYPE = new TypeToken<HashMap<String, List<SearchResult.RegionPayload>>>(){}.getType();
    private static final String LEET_HACK = "http://{";
    private static final String COUNTRY_DEFAULT = "def";
    @Inject
    AccountService mAccountService;
    private static final int FAB_SCROLL_SLOP = 20;
    @Inject
    Gson mGson;
    @Nullable
    IqWebView mWebView;
    @BindView(value=2131689634)
    ViewGroup mWebViewContainer;
    @Nullable
    @BindView(value=2131689635)
    ProgressBar mProgressBar;
    private IqWebViewClient mWebViewClient;
    private IqWebChromeClient mWebChromeClient;
    @BindView(value=2131689637)
    ViewGroup mVideoView;
    @BindView(value=2131689633)
    ViewGroup mContentView;
    @BindView(value=2131689639)
    FloatingActionsMenu mFab;
    @BindView(value=2131689640)
    FloatingActionButton mFavouriteItem;
    @BindView(value=2131689638)
    View mFabShimView;
    @Nullable
    private TextView mSearchResultTitle;
    @Nullable
    private String mCurrentUrl;
    @NonNull
    private String mUserCountryCode;
    @Nullable
    private Fragment mSubFragmentInstance;
    @Nullable
    private SearchResult mSearchResult;

    public static SearchResultFragment newInstance() {
        return new SearchResultFragment();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((BaseActivity)this.getActivity()).getActivityComponent().inject(this);
        this.mUserCountryCode = DeviceUtils.getCountryCodeLowerCase(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_search_result, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        log.debug("view created, current url: {}", (Object)this.mCurrentUrl);
        this.setupWebView();
        if (savedInstanceState == null && this.mCurrentUrl != null) {
            this.changeWebViewContent(Uri.parse((String)this.mCurrentUrl), null);
        }
        this.mSearchResultTitle = (TextView)this.getActivity().findViewById(R.id.search_result_title);
        this.mFab.setOnFloatingActionsMenuUpdateListener(new FloatingActionsMenu.OnFloatingActionsMenuUpdateListener(){

            @Override
            public void onMenuExpanded() {
                SearchResultFragment.this.mFabShimView.animate().alpha(1.0f).withLayer().start();
                SearchResultFragment.this.mFabShimView.setOnClickListener(SearchResultFragment$2$$Lambda$1.lambdaFactory$(this));
                SearchResultFragment.this.mFabShimView.setClickable(true);
            }

            @Override
            public void onMenuCollapsed() {
                SearchResultFragment.this.mFabShimView.animate().alpha(0.0f).withLayer().start();
                SearchResultFragment.this.mFabShimView.setOnClickListener(null);
                SearchResultFragment.this.mFabShimView.setClickable(false);
            }

            /* synthetic */ void lambda$onMenuExpanded$0(View v) {
                SearchResultFragment.this.mFab.collapse();
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @OnClick(value={2131689640})
    void onFavouriteButtonClick() {
        if (this.mSearchResult != null) {
            this.mSearchResult.setFavourite(!this.mSearchResult.isFavourite());
            this.mAccountService.updateEntryForResult(this.mSearchResult);
            this.updateFavouriteItem();
        }
    }

    private void updateFavouriteItem() {
        boolean isFavourite = this.mSearchResult != null && this.mSearchResult.isFavourite();
        this.mFavouriteItem.setIcon(isFavourite ? R.drawable.ic_hearts_filled : R.drawable.ic_hearts_empty);
        this.mFavouriteItem.setTitle(isFavourite ? R.string.remove_from_favourites : R.string.add_to_favourites);
        if (this.mSearchResult != null) {
            int visibility = this.mSearchResult.getTriggerType() == null ? 8 : 0;
            this.mFavouriteItem.setVisibility(visibility);
        }
    }

    @OnClick(value={2131689641})
    void onShareButtonClick() {
        if (this.mCurrentUrl != null) {
            this.mFab.collapse();
            IntentUtils.shareIqnectContent(this.getContext(), this.mCurrentUrl);
        }
    }

    public void loadSearchResult(@Nullable SearchResult searchResult) {
        this.mSearchResult = searchResult;
        if (searchResult != null) {
            this.mAccountService.synchroniseResult(this.mSearchResult);
            this.updateFavouriteItem();
        }
        log.debug("load search result: {}", (Object)searchResult);
        if (searchResult == null) {
            return;
        }
        SearchResult.RegionPayload regionPayload = this.getPayload(searchResult);
        searchResult.updateResult(regionPayload);
        Uri uri = Uri.parse((String)searchResult.getPayload());
        String html = searchResult.getHtml();
        this.changeWebViewContent(uri, html);
        this.onSearchFinished(searchResult);
    }

    @Nullable
    private SearchResult.RegionPayload getPayload(@NonNull SearchResult searchResult) {
        if (searchResult == null) {
            throw new NullPointerException("searchResult");
        }
        String payloadString = searchResult.getPayload();
        if (payloadString == null) {
            return null;
        }
        String jsonString = payloadString.replace(LEET_HACK, "{");
        SearchResult.RegionPayload payload = null;
        try {
            HashMap payloadMap = (HashMap)this.mGson.fromJson(jsonString, PAYLOAD_MAP_TYPE);
            List payloads = (List)payloadMap.get(this.mUserCountryCode);
            if (payloads == null) {
                payloads = (List)payloadMap.get(COUNTRY_DEFAULT);
            }
            if (payloads != null) {
                payload = (SearchResult.RegionPayload)payloads.get(0);
            }
        }
        catch (Throwable t) {
            log.error("error parsing payload {}", (Object)jsonString, (Object)t);
        }
        return payload;
    }

    public void setSubFragment(@Nullable Fragment fragment) {
        this.mSubFragmentInstance = fragment;
    }

    public void showSubFragment() {
        if (this.mSubFragmentInstance == null) {
            return;
        }
        log.debug("showing sub fragment: {}", (Object)this.mSubFragmentInstance);
        ExtendedFragmentManager childExtendedFragmentManager = this.getChildExtendedFragmentManager();
        childExtendedFragmentManager.beginTransaction().replace(R.id.sub_fragment, this.mSubFragmentInstance, ExtendedFragmentManager.defaultTag(this.mSubFragmentInstance)).commitAllowingStateLoss();
    }

    private void onSearchFinished(@NonNull SearchResult result) {
        if (result == null) {
            throw new NullPointerException("result");
        }
        this.mAccountService.logMatch(result);
        String searchBarTitle = result.getSearchbarTitle();
        if (TextUtils.isEmpty((CharSequence)result.getHtml()) && !StringUtils.isNullOrEmpty((String)searchBarTitle)) {
            if (this.mSearchResultTitle != null) {
                this.mSearchResultTitle.setText((CharSequence)searchBarTitle);
            }
            NotificationDialogFragment dialogFragment = new NotificationDialogFragment();
            dialogFragment.setText(searchBarTitle);
            dialogFragment.show((AppCompatActivity)this.getActivity());
        }
    }

    @Nullable
    public String getWebViewUrl() {
        return this.mWebView == null ? null : this.mWebView.getUrl();
    }

    private boolean tryHandleUri(@Nullable Uri uri) {
        if (uri == null) {
            return false;
        }
        boolean handled = this.getUriHandler().handleUri((Context)this.getActivity(), uri);
        if (handled) {
            return true;
        }
        if (SearchResultFragment.isCloseUrl(uri)) {
            this.mWebViewClient.addListener(new IqWebViewClient.SimpleWebViewListener(){

                @Override
                public void onPageFinished(WebView view, String url) {
                    view.clearHistory();
                    view.loadUrl(SearchResultFragment.this.mCurrentUrl);
                    SearchResultFragment.this.mWebViewClient.removeListener(this);
                }
            });
            return false;
        }
        String scheme = uri.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme) || "about".equals(scheme)) {
            return false;
        }
        if (!this.openBrowsable(uri)) {
            this.showToast(R.string.iqnect_cannot_open_page);
        }
        return true;
    }

    private boolean tryHandleUri(@Nullable String url) {
        return url != null && this.tryHandleUri(Uri.parse((String)url));
    }

    private static boolean isCloseUrl(@NonNull Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        String authority = uri.getAuthority();
        String encodedPath = uri.getEncodedPath();
        if (authority == null) {
            return false;
        }
        if (authority.contains("facebook.com") && encodedPath != null) {
            return encodedPath.contains("dialog/return/close") || encodedPath.contains("plugins/close_popup");
        }
        if (authority.contains("cnn.com")) {
            return uri.toString().contains("/bookmark.aspx?close=true");
        }
        return false;
    }

    private boolean openBrowsable(@NonNull Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        try {
            this.startActivity(new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE"));
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
        }
        catch (Exception e) {
            log.error("Error opening browsable URL: {}", (Object)uri, (Object)e);
        }
        return false;
    }

    public void changeWebViewContent(@Nullable Uri uri, @Nullable String html) {
        String uriString;
        log.debug("changeUri: uri={}, html={}", (Object)uri, (Object)html);
        String currentUrl = this.getWebViewUrl();
        this.mCurrentUrl = uriString = uri == null ? null : uri.toString();
        boolean isHtml = !TextUtils.isEmpty((CharSequence)html);
        log.debug("current url: {}, webview: {}", (Object)currentUrl, (Object)this.mWebView);
        this.setWebViewVisibility(0);
        if (isHtml) {
            this.setupWebView();
            if (this.mWebView != null) {
                this.mWebViewClient.clearHistory();
                this.mWebView.loadData(html, "text/html; charset=UTF-8", null);
                this.mWebView.requestFocus();
            }
        } else if (!this.tryHandleUri(uri)) {
            if (uri != null) {
                if (this.mWebView != null && !Objects.equal((Object)currentUrl, (Object)uriString)) {
                    this.mWebViewClient.clearHistory();
                    this.mWebView.loadUrl(uriString);
                    this.mWebView.requestFocus();
                }
            } else if (this.mWebView != null) {
                this.mWebViewClient.clearHistory();
            }
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setupWebView() {
        if (this.mWebViewContainer == null) {
            log.error("setupWebView -- web view container is null");
            return;
        }
        this.mWebViewContainer.removeAllViews();
        if (this.mWebView != null) {
            log.debug("destroy old web view");
            this.mWebView.onPause();
            this.mWebView.destroy();
            this.mWebView = null;
        }
        log.debug("initialising web view");
        this.mWebView = new IqWebView((Context)this.getActivity());
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mWebView.useDownloadManager(true);
        WebSettings settings = this.mWebView.getSettings();
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setAppCacheEnabled(true);
        settings.setAppCachePath(this.appCachePath());
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(false);
        settings.setJavaScriptEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        this.mWebViewContainer.addView((View)this.mWebView);
        if (this.mWebViewClient == null) {
            this.mWebViewClient = new IqWebViewClient((Context)this.getActivity());
            this.mWebViewClient.addListener(new IqWebViewClient.WebViewListener(){

                @Override
                public void onPageStarted(@NonNull WebView view, @NonNull String url) {
                    if (view == null) {
                        throw new NullPointerException("view");
                    }
                    if (url == null) {
                        throw new NullPointerException("url");
                    }
                    SearchResultFragment.this.setProgressBarProgress(0);
                    SearchResultFragment.this.setProgressBarVisibility(0);
                    SearchResultFragment.this.setFabVisible(false);
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    SearchResultFragment.this.setProgressBarProgress(100);
                    SearchResultFragment.this.setProgressBarVisibility(8);
                    SearchResultFragment.this.setFabVisible(true);
                }

                @Override
                public boolean shouldOverrideUrlLoading(String url) {
                    return SearchResultFragment.this.tryHandleUri(url);
                }
            });
        }
        if (this.mWebChromeClient == null) {
            this.mWebChromeClient = new SearchResultWebChromeClient(this, (View)this.mContentView, this.mVideoView);
            this.mWebChromeClient.setOnToggledFullscreen(SearchResultFragment$$Lambda$1.lambdaFactory$(this));
        }
        this.mWebView.setWebViewClient(this.mWebViewClient);
        this.mWebView.setWebChromeClient(this.mWebChromeClient);
        this.mWebView.setScrollChangeListener(SearchResultFragment$$Lambda$2.lambdaFactory$(this));
    }

    private void toggleFullScreenVideo(boolean fullscreen) {
        SearchResultActivity activity = (SearchResultActivity)this.getActivity();
        log.debug("toggleFullScreenNoActionBar={}", (Object)fullscreen);
        if (activity != null) {
            activity.setRequestedOrientation(fullscreen ? -1 : 7);
            activity.toggleFullScreenNoActionBar(fullscreen);
        }
    }

    private void setProgressBarProgress(int progress) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgress(progress);
        }
    }

    private void setProgressBarVisibility(int visibility) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(visibility);
        }
    }

    private void setFabVisible(boolean visible) {
        if (this.mFab != null) {
            if (visible) {
                this.mFab.show();
            } else {
                this.mFab.hide();
            }
        }
    }

    @NonNull
    private String appCachePath() {
        return this.getActivity().getCacheDir().getAbsolutePath();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.mWebView != null) {
            this.mWebView.onPause();
        }
    }

    @Override
    public void onDestroyView() {
        if (this.mWebViewContainer != null) {
            this.mWebViewContainer.removeAllViews();
            this.mWebViewContainer = null;
        }
        if (this.mWebView != null) {
            if (!this.mWebView.isShown()) {
                this.mWebView.stopLoading();
            }
            this.mWebView.setWebChromeClient(null);
            this.mWebView.setWebViewClient(null);
            this.mWebView.destroy();
            this.mWebView = null;
        }
        super.onDestroyView();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.onResume();
        }
    }

    @Override
    public void onDestroy() {
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.destroy();
            this.mWebChromeClient = null;
        }
        super.onDestroy();
    }

    public void setWebViewVisibility(int visibility) {
        int currentVisibility;
        if (this.mWebView != null && visibility != (currentVisibility = this.mWebViewContainer.getVisibility())) {
            this.mWebViewContainer.setVisibility(visibility);
            if (visibility != 0) {
                this.mWebView.onPause();
            } else {
                this.mWebView.onResume();
            }
        }
    }

    public boolean onBackPressed() {
        if (this.mFab.isExpanded()) {
            this.mFab.collapse();
            return true;
        }
        if (this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return false;
    }

    /* synthetic */ void lambda$setupWebView$0(WebView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        int dy = scrollY - oldScrollY;
        if (dy > 20) {
            this.setFabVisible(false);
        } else if (dy < -20) {
            this.setFabVisible(true);
        }
    }

    static /* synthetic */ void access$lambda$0(SearchResultFragment searchResultFragment, boolean bl) {
        searchResultFragment.toggleFullScreenVideo(bl);
    }

    private static final class SearchResultWebChromeClient
    extends IqWebChromeClient {
        private final WeakReference<SearchResultFragment> mFragment;

        SearchResultWebChromeClient(@NonNull SearchResultFragment fragment, @Nullable View nonVideoView, @Nullable ViewGroup videoView) {
            super(nonVideoView, videoView);
            if (fragment == null) {
                throw new NullPointerException("fragment");
            }
            this.mFragment = new WeakReference<SearchResultFragment>(fragment);
        }

        public void onProgressChanged(WebView view, int progress) {
            super.onProgressChanged(view, progress);
            SearchResultFragment fragment = (SearchResultFragment)((Object)this.mFragment.get());
            if (fragment != null) {
                fragment.setProgressBarProgress(progress);
            }
        }
    }
}

