/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import butterknife.OnClick;
import lombok.NonNull;
import org.iqnect.iqkit.model.SearchResult;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.app.SearchResultActivity$$Lambda$1;
import org.iqnect.iqkit.ui.app.SearchResultActivity$$Lambda$2;
import org.iqnect.iqkit.ui.app.SearchResultActivity$$Lambda$3;
import org.iqnect.iqkit.ui.app.SearchResultFragment;
import org.iqnect.iqkit.ui.web.WebFragment;
import org.parceler.Parcels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultActivity
extends BaseActivity {
    private static final Logger log = LoggerFactory.getLogger(SearchResultActivity.class);
    private static final String ACTION_SEARCH_RESULT_ACTIVITY = "org.iqnect.iqkit.action.ACTION_SEARCH_RESULT_ACTIVITY";
    private static final String EXTRA_SEARCH_RESULT = "searchResult";
    private static final String EXTRA_WEB_URI = "webUri";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        SearchResultFragment fragment;
        super.onCreate(savedInstanceState);
        this.getActivityComponent().inject(this);
        this.setContentView(R.layout.activity_search_result);
        SearchResult searchResult = (SearchResult)Parcels.unwrap((Parcelable)this.getIntent().getParcelableExtra(EXTRA_SEARCH_RESULT));
        if (savedInstanceState == null) {
            fragment = SearchResultFragment.newInstance();
            this.getSupportFragmentManager().beginTransaction().add(R.id.fragment, (Fragment)fragment, SearchResultFragment.class.getSimpleName()).commit();
        } else {
            fragment = (SearchResultFragment)this.getSupportFragmentManager().findFragmentByTag(SearchResultFragment.class.getSimpleName());
        }
        this.runOnResume(SearchResultActivity$$Lambda$1.lambdaFactory$(fragment, searchResult));
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        log.debug("new intent: {}", (Object)intent);
        this.setIntent(intent);
        this.handleIntent(intent);
    }

    public void handleIntent(@NonNull Intent intent) {
        if (intent == null) {
            throw new NullPointerException("intent");
        }
        Uri webUri = (Uri)intent.getParcelableExtra(EXTRA_WEB_URI);
        this.runOnResume(SearchResultActivity$$Lambda$2.lambdaFactory$(this, webUri));
    }

    protected void openWebFragment(@NonNull Uri uri, @Nullable String searchQuery) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        SearchResultFragment fragment = (SearchResultFragment)this.getSupportFragmentManager().findFragmentByTag(SearchResultFragment.class.getSimpleName());
        fragment.setSubFragment((Fragment)WebFragment.create(uri.toString(), searchQuery));
        fragment.showSubFragment();
    }

    public void onBackPressed() {
        SearchResultFragment fragment = (SearchResultFragment)this.getSupportFragmentManager().findFragmentByTag(SearchResultFragment.class.getSimpleName());
        if (!fragment.onBackPressed()) {
            super.onBackPressed();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @NonNull
    public static Intent getSearchResultMainIntent(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Intent intent = new Intent(ACTION_SEARCH_RESULT_ACTIVITY);
        intent.setFlags(0x20000000).setFlags(0x4000000);
        intent.setPackage(context.getPackageName());
        return intent;
    }

    @NonNull
    public static Intent getSearchResultIntent(@NonNull Context context, @NonNull SearchResult result) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (result == null) {
            throw new NullPointerException("result");
        }
        return SearchResultActivity.getSearchResultMainIntent(context).putExtra(EXTRA_SEARCH_RESULT, Parcels.wrap(SearchResult.class, (Object)result));
    }

    @NonNull
    public static Intent getWebFragmentIntent(@NonNull Context context, @NonNull Uri uri) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        return SearchResultActivity.getSearchResultMainIntent(context).putExtra(EXTRA_WEB_URI, (Parcelable)uri);
    }

    @OnClick(value={2131689598})
    public void onCloseClick() {
        this.finish();
    }

    /* synthetic */ void lambda$handleIntent$2(Uri webUri) {
        if (webUri != null) {
            this.openWebFragment(webUri, null);
        }
    }

    static /* synthetic */ void lambda$onCreate$1(SearchResultFragment fragment, SearchResult searchResult) {
        fragment.runOnResume(SearchResultActivity$$Lambda$3.lambdaFactory$(fragment, searchResult));
    }

    static /* synthetic */ void lambda$null$0(SearchResultFragment fragment, SearchResult searchResult) {
        fragment.loadSearchResult(searchResult);
    }
}

