/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import butterknife.BindView;
import javax.annotation.Nullable;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.NoTitleDialogFragment;
import org.iqnect.iqkit.ui.app.NotificationDialogFragment$$Lambda$1;
import org.iqnect.iqkit.ui.widget.IQTextView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDialogFragment
extends NoTitleDialogFragment {
    private static final Logger log = LoggerFactory.getLogger(NotificationDialogFragment.class);
    private static final String FRAGMENT_TAG = NotificationDialogFragment.class.getCanonicalName();
    @BindView(value=2131689646)
    IQTextView mTextView;
    @BindView(value=2131689645)
    ImageView mImageView;
    private String mText;
    private boolean mSuccess = true;
    private boolean mScheduledDismiss = false;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.notification_dialog, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.updateView();
    }

    public void show(AppCompatActivity activity) {
        if (!activity.isFinishing()) {
            FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();
            transaction.setTransition(4097);
            transaction.add((Fragment)this, FRAGMENT_TAG).commitAllowingStateLoss();
            this.mScheduledDismiss = false;
        }
    }

    public void hide(AppCompatActivity activity) {
        if (!activity.isFinishing()) {
            activity.getSupportFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void setText(String text) {
        this.mText = text;
        this.updateView();
    }

    public void setSuccess(boolean success) {
        this.mSuccess = success;
        this.updateView();
    }

    private void updateView() {
        if (this.getView() == null) {
            return;
        }
        int drawableId = this.mSuccess ? R.drawable.notification_success : R.drawable.notification_error;
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)drawableId, null);
        log.debug("notification text: {}", (Object)this.mText);
        this.mTextView.setText(this.mText);
        this.mImageView.setImageDrawable(drawable2);
        this.getView().requestLayout();
        if (this.mText != null && this.getView() != null && !this.mScheduledDismiss) {
            long delay = (long)Math.min((double)this.mText.length() * 0.06 + 1.0, 5.0) * 1000L;
            this.getView().postDelayed(NotificationDialogFragment$$Lambda$1.lambdaFactory$(this), delay);
            this.mScheduledDismiss = true;
        }
    }
}

