/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ExtendedFragmentManager
extends FragmentManager {
    @NonNull
    private final Context mContext;
    @NonNull
    private final FragmentManager mFragmentManager;

    public ExtendedFragmentManager(@NonNull Context context, @NonNull FragmentManager fragmentManager) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (fragmentManager == null) {
            throw new NullPointerException("fragmentManager");
        }
        this.mContext = context.getApplicationContext();
        this.mFragmentManager = fragmentManager;
    }

    @NonNull
    public <T extends Fragment> T findByTagOrCreate(@NonNull Class<? extends Fragment> fragmentClass) {
        if (fragmentClass == null) {
            throw new NullPointerException("fragmentClass");
        }
        Object fragment = this.findByTag(fragmentClass);
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this.mContext, (String)fragmentClass.getName());
        }
        return fragment;
    }

    @Nullable
    public <T extends Fragment> T findByTag(@NonNull Class<? extends Fragment> fragmentClass) {
        if (fragmentClass == null) {
            throw new NullPointerException("fragmentClass");
        }
        return this.findByTag(ExtendedFragmentManager.defaultTag(fragmentClass));
    }

    @Nullable
    public <T extends Fragment> T findByTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag");
        }
        return (T)this.mFragmentManager.findFragmentByTag(tag);
    }

    @Nullable
    public <T extends Fragment> T findById(int fragmentId) {
        return (T)this.mFragmentManager.findFragmentById(fragmentId);
    }

    @Nullable
    public FragmentManager.BackStackEntry getCurrentBackStackEntry() {
        int count = this.getBackStackEntryCount();
        if (count <= 0) {
            return null;
        }
        return this.getBackStackEntryAt(count - 1);
    }

    @NonNull
    public static String defaultTag(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        return fragment.getClass().getName();
    }

    @NonNull
    public static String defaultTag(@NonNull Class<? extends Fragment> fragmentClass) {
        if (fragmentClass == null) {
            throw new NullPointerException("fragmentClass");
        }
        return fragmentClass.getName();
    }

    public FragmentTransaction beginTransaction() {
        return this.mFragmentManager.beginTransaction();
    }

    @Deprecated
    public FragmentTransaction openTransaction() {
        return this.mFragmentManager.openTransaction();
    }

    public boolean executePendingTransactions() {
        return this.mFragmentManager.executePendingTransactions();
    }

    public Fragment findFragmentById(int arg0) {
        return this.mFragmentManager.findFragmentById(arg0);
    }

    public Fragment findFragmentByTag(String arg0) {
        return this.mFragmentManager.findFragmentByTag(arg0);
    }

    public void popBackStack() {
        this.mFragmentManager.popBackStack();
    }

    public boolean popBackStackImmediate() {
        return this.mFragmentManager.popBackStackImmediate();
    }

    public void popBackStack(String arg0, int arg1) {
        this.mFragmentManager.popBackStack(arg0, arg1);
    }

    public boolean popBackStackImmediate(String arg0, int arg1) {
        return this.mFragmentManager.popBackStackImmediate(arg0, arg1);
    }

    public void popBackStack(int arg0, int arg1) {
        this.mFragmentManager.popBackStack(arg0, arg1);
    }

    public boolean popBackStackImmediate(int arg0, int arg1) {
        return this.mFragmentManager.popBackStackImmediate(arg0, arg1);
    }

    public int getBackStackEntryCount() {
        return this.mFragmentManager.getBackStackEntryCount();
    }

    public FragmentManager.BackStackEntry getBackStackEntryAt(int arg0) {
        return this.mFragmentManager.getBackStackEntryAt(arg0);
    }

    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener arg0) {
        this.mFragmentManager.addOnBackStackChangedListener(arg0);
    }

    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener arg0) {
        this.mFragmentManager.removeOnBackStackChangedListener(arg0);
    }

    public void putFragment(Bundle arg0, String arg1, Fragment arg2) {
        this.mFragmentManager.putFragment(arg0, arg1, arg2);
    }

    public Fragment getFragment(Bundle arg0, String arg1) {
        return this.mFragmentManager.getFragment(arg0, arg1);
    }

    public List<Fragment> getFragments() {
        return this.mFragmentManager.getFragments();
    }

    public Fragment.SavedState saveFragmentInstanceState(Fragment arg0) {
        return this.mFragmentManager.saveFragmentInstanceState(arg0);
    }

    public boolean isDestroyed() {
        return this.mFragmentManager.isDestroyed();
    }

    public void registerFragmentLifecycleCallbacks(FragmentManager.FragmentLifecycleCallbacks arg0, boolean arg1) {
        this.mFragmentManager.registerFragmentLifecycleCallbacks(arg0, arg1);
    }

    public void unregisterFragmentLifecycleCallbacks(FragmentManager.FragmentLifecycleCallbacks arg0) {
        this.mFragmentManager.unregisterFragmentLifecycleCallbacks(arg0);
    }

    public void dump(String arg0, FileDescriptor arg1, PrintWriter arg2, String[] arg3) {
        this.mFragmentManager.dump(arg0, arg1, arg2, arg3);
    }
}

