/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.view.View;
import butterknife.Unbinder;
import com.squareup.otto.Bus;
import com.trello.rxlifecycle.components.support.RxFragment;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.analytics.AnalyticsProxy;
import org.iqnect.iqkit.model.Event;
import org.iqnect.iqkit.ui.app.Alerts;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.app.ExtendedFragmentManager;
import org.iqnect.iqkit.ui.app.Toasts;
import org.iqnect.iqkit.ui.uri.UriHandler;
import org.iqnect.iqkit.ui.util.ButterKnifeUtil;
import org.iqnect.iqkit.util.RunnableQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;

public abstract class BaseFragment
extends RxFragment {
    private static final Logger log = LoggerFactory.getLogger(BaseFragment.class);
    @Inject
    Bus mBus;
    @Inject
    Toasts mToasts;
    @Inject
    Alerts mAlerts;
    @Inject
    AnalyticsProxy mAnalyticsProxy;
    @Inject
    UriHandler mUriHandler;
    @Nullable
    private ExtendedFragmentManager mChildExtendedFragmentManager;
    @NonNull
    private final RunnableQueue mRunOnResume = new RunnableQueue();
    @NonNull
    private final CompositeSubscription mCompositeSubscription = new CompositeSubscription();
    @Nullable
    private Unbinder mUnbinder;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BaseActivity activity = (BaseActivity)this.getActivity();
        activity.getActivityComponent().inject(this);
        log.debug("injected!  bus = {}", (Object)this.mBus);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mUnbinder = ButterKnifeUtil.bind((Object)this, view);
    }

    public void onDestroy() {
        this.mCompositeSubscription.unsubscribe();
        super.onDestroy();
        this.mAlerts = null;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mUnbinder != null) {
            this.mUnbinder.unbind();
        }
    }

    public void onResume() {
        super.onResume();
        this.mRunOnResume.flush();
        this.mBus.register((Object)this);
    }

    public void onPause() {
        super.onPause();
        this.mBus.unregister((Object)this);
    }

    protected boolean requireNetworkConnection() {
        BaseActivity activity = this.getBaseActivity();
        return activity != null && activity.requireNetworkConnection();
    }

    public void runOnResume(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        this.mRunOnResume.execute(runnable);
    }

    @NonNull
    public ExtendedFragmentManager getChildExtendedFragmentManager() {
        if (this.mChildExtendedFragmentManager == null) {
            this.mChildExtendedFragmentManager = new ExtendedFragmentManager((Context)this.getActivity(), this.getChildFragmentManager());
        }
        return this.mChildExtendedFragmentManager;
    }

    public static void dismissIfShowing(@Nullable AlertDialog dialog) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    @Nullable
    public final BaseActivity getBaseActivity() {
        return (BaseActivity)this.getActivity();
    }

    protected final void addSubscription(@NonNull Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription");
        }
        this.mCompositeSubscription.add(subscription);
    }

    public Bus getBus() {
        return this.mBus;
    }

    public UriHandler getUriHandler() {
        return this.mUriHandler;
    }

    public void showToast(CharSequence msg) {
        this.mToasts.showToast(msg);
    }

    public void showToast(int stringResId) {
        this.mToasts.showToast(stringResId);
    }

    public void showToast(Throwable e) {
        this.mToasts.showToast(e);
    }

    public AlertDialog.Builder buildDialog() {
        return this.mAlerts.buildDialog();
    }

    public Dialog showAlertDialog(int messageId) {
        return this.mAlerts.showAlertDialog(messageId);
    }

    public Dialog showErrorDialog(Throwable e) {
        return this.mAlerts.showErrorDialog(e);
    }

    public void analyticsEvent(Event.Category category, Event.Action action) {
        this.mAnalyticsProxy.analyticsEvent(category, action);
    }

    public void analyticsEvent(Event.Category category, Event.Action action, String label) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label);
    }

    public void analyticsEvent(Event.Category category, Event.Action action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    public void analyticsEvent(Event.Category category, String action, String label) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label);
    }

    public void analyticsEvent(Event.Category category, String action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    public void analyticsEvent(String category, String action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }
}

