/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.app.AlertDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import butterknife.Unbinder;
import com.squareup.otto.Bus;
import com.trello.rxlifecycle.components.support.RxDialogFragment;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.ui.app.Alerts;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.app.Toasts;
import org.iqnect.iqkit.ui.util.ButterKnifeUtil;
import org.iqnect.iqkit.util.RunnableQueue;

public abstract class BaseDialogFragment
extends RxDialogFragment {
    @Inject
    Bus mBus;
    @Inject
    Toasts mToasts;
    @Inject
    Alerts mAlerts;
    @NonNull
    private final RunnableQueue mRunOnResume = new RunnableQueue();
    @Nullable
    private Unbinder mUnbinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BaseActivity activity = (BaseActivity)this.getActivity();
        activity.getActivityComponent().inject(this);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mUnbinder = ButterKnifeUtil.bind((Object)this, view);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mAlerts = null;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mUnbinder != null) {
            this.mUnbinder.unbind();
        }
    }

    public void onResume() {
        super.onResume();
        this.mRunOnResume.flush();
        this.mBus.register((Object)this);
    }

    public void onPause() {
        super.onPause();
        this.mBus.unregister((Object)this);
    }

    public void runOnResume(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        this.mRunOnResume.execute(runnable);
    }

    public Bus getBus() {
        return this.mBus;
    }

    public void showToast(CharSequence msg) {
        this.mToasts.showToast(msg);
    }

    public void showToast(int stringResId) {
        this.mToasts.showToast(stringResId);
    }

    public void showToast(Throwable e) {
        this.mToasts.showToast(e);
    }

    public AlertDialog.Builder buildDialog() {
        return this.mAlerts.buildDialog();
    }

    public Dialog showAlertDialog(int messageId) {
        return this.mAlerts.showAlertDialog(messageId);
    }

    public Dialog showErrorDialog(Throwable e) {
        return this.mAlerts.showErrorDialog(e);
    }
}

