/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.view.MenuItem;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import com.trello.rxlifecycle.components.support.RxAppCompatActivity;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.analytics.AnalyticsProxy;
import org.iqnect.iqkit.api.AppUpdate;
import org.iqnect.iqkit.model.Event;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.ActivityComponent;
import org.iqnect.iqkit.ui.app.Alerts;
import org.iqnect.iqkit.ui.app.AppUpdateDialogFragment;
import org.iqnect.iqkit.ui.app.BaseActivity$$Lambda$1;
import org.iqnect.iqkit.ui.app.BaseFragment;
import org.iqnect.iqkit.ui.app.DaggerActivityComponent;
import org.iqnect.iqkit.ui.app.ExtendedFragmentManager;
import org.iqnect.iqkit.ui.app.Toasts;
import org.iqnect.iqkit.ui.injection.ActivityModule;
import org.iqnect.iqkit.ui.injection.UIComponentFactory;
import org.iqnect.iqkit.ui.util.ButterKnifeUtil;
import org.iqnect.iqkit.ui.util.ConnectivityUtils;
import org.iqnect.iqkit.util.ForegroundTracker;
import org.iqnect.iqkit.util.RunnableQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;

public abstract class BaseActivity
extends RxAppCompatActivity {
    private static final Logger log = LoggerFactory.getLogger(BaseActivity.class);
    @Inject
    Bus mBus;
    @Inject
    ForegroundTracker mForegroundTracker;
    @Inject
    Toasts mToasts;
    @Inject
    Alerts mAlerts;
    @Inject
    AnalyticsProxy mAnalyticsProxy;
    @NonNull
    private ExtendedFragmentManager mExtendedFragmentManager;
    @NonNull
    private final RunnableQueue mRunOnResume = new RunnableQueue();
    private boolean mActivityResumed;
    private boolean mActivityDestroyed;
    @NonNull
    private final CompositeSubscription mCompositeSubscription = new CompositeSubscription();
    @Nullable
    private AlertDialog mErrorDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getActivityComponent().inject(this);
        this.supportRequestWindowFeature(2);
        this.mExtendedFragmentManager = new ExtendedFragmentManager((Context)this, this.getSupportFragmentManager());
    }

    public void onContentChanged() {
        super.onContentChanged();
        ButterKnifeUtil.bind((Activity)this);
    }

    protected void onResume() {
        super.onResume();
        this.mBus.register((Object)this);
        this.mActivityResumed = true;
        this.mForegroundTracker.notifyActivityResumed();
        this.mRunOnResume.flush();
    }

    protected void onPause() {
        super.onPause();
        this.mActivityResumed = false;
        this.mForegroundTracker.notifyActivityPaused();
        this.mBus.unregister((Object)this);
        BaseFragment.dismissIfShowing(this.mErrorDialog);
        this.mErrorDialog = null;
    }

    protected void onDestroy() {
        this.mActivityDestroyed = true;
        this.mCompositeSubscription.unsubscribe();
        super.onDestroy();
    }

    protected void showErrorDialog(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.mErrorDialog == null) {
            this.mErrorDialog = new AlertDialog.Builder((Context)this, R.style.AlertDialogTheme).setMessage((CharSequence)message).setPositiveButton(17039370, BaseActivity$$Lambda$1.lambdaFactory$()).create();
        }
        if (!this.mErrorDialog.isShowing()) {
            this.mErrorDialog.show();
        }
    }

    protected boolean requireNetworkConnection() {
        if (!ConnectivityUtils.hasConnection((Context)this)) {
            this.showErrorDialog(this.getString(R.string.no_internet_msg));
            return false;
        }
        return true;
    }

    protected void tryStartActivity(@NonNull Intent intent) {
        if (intent == null) {
            throw new NullPointerException("intent");
        }
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            log.error("no activity found for intent", (Throwable)e);
            this.showToast(R.string.error_message_activity_not_found);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == 16908332) {
            log.debug("home button pressed, navigating up");
            this.goUp();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void goUp() {
        this.finish();
    }

    protected void hideActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    protected void showActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.show();
        }
    }

    protected final void addSubscription(@NonNull Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription");
        }
        this.mCompositeSubscription.add(subscription);
    }

    public void toggleFullScreenNoActionBar(boolean fullscreen) {
        this.toggleStatusBar(!fullscreen);
        if (fullscreen) {
            this.hideActionBar();
        } else {
            this.showActionBar();
        }
    }

    private void toggleStatusBar(boolean showStatusBar) {
        if (showStatusBar) {
            this.getWindow().clearFlags(1024);
        } else {
            this.getWindow().addFlags(1024);
        }
    }

    @Subscribe
    private void onUpdateAvailable(@NonNull AppUpdate.Event updateEvent) {
        if (updateEvent == null) {
            throw new NullPointerException("updateEvent");
        }
        AppUpdateDialogFragment.show(this.getSupportFragmentManager(), updateEvent.getUpdate().isRequired());
    }

    @NonNull
    public ActivityComponent getActivityComponent() {
        return DaggerActivityComponent.builder().uIComponent(UIComponentFactory.getInstance((Context)this)).activityModule(new ActivityModule((Activity)this)).build();
    }

    public void runOnResume(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        this.mRunOnResume.execute(runnable);
    }

    public Bus getBus() {
        return this.mBus;
    }

    @NonNull
    public ExtendedFragmentManager getExtendedFragmentManager() {
        return this.mExtendedFragmentManager;
    }

    public boolean isActivityResumed() {
        return this.mActivityResumed;
    }

    public boolean isActivityDestroyed() {
        return this.mActivityDestroyed;
    }

    public void showToast(CharSequence msg) {
        this.mToasts.showToast(msg);
    }

    public void showToast(int stringResId) {
        this.mToasts.showToast(stringResId);
    }

    public void showToast(Throwable e) {
        this.mToasts.showToast(e);
    }

    public AlertDialog.Builder buildDialog() {
        return this.mAlerts.buildDialog();
    }

    public Dialog showAlertDialog(int messageId) {
        return this.mAlerts.showAlertDialog(messageId);
    }

    public Dialog showErrorDialog(Throwable e) {
        return this.mAlerts.showErrorDialog(e);
    }

    public void analyticsEvent(Event.Category category, Event.Action action) {
        this.mAnalyticsProxy.analyticsEvent(category, action);
    }

    public void analyticsEvent(Event.Category category, Event.Action action, String label) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label);
    }

    public void analyticsEvent(Event.Category category, Event.Action action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    public void analyticsEvent(Event.Category category, String action, String label) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label);
    }

    public void analyticsEvent(Event.Category category, String action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    public void analyticsEvent(String category, String action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    static /* synthetic */ void lambda$showErrorDialog$0(DialogInterface dialog, int which) {
        dialog.dismiss();
    }
}

