/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui;

import android.content.Context;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.ui.R;
import retrofit.RetrofitError;

public class Errors {
    @NonNull
    private final Context mContext;

    @Inject
    public Errors(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.mContext = context;
    }

    @NonNull
    public String getTitle(@NonNull Throwable e) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        return this.mContext.getString(R.string.error);
    }

    @NonNull
    public String getMessage(@NonNull Throwable e) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        return this.getMessage(e, null);
    }

    @NonNull
    public String getMessage(@NonNull Throwable e, @Nullable String defaultMessage) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        if (Errors.isCausedByTimeout(e)) {
            return this.mContext.getString(R.string.error_message_timeout);
        }
        if (e instanceof SocketException) {
            return this.mContext.getString(R.string.error_message_connection_failed);
        }
        if (e instanceof UnknownHostException) {
            return this.mContext.getString(R.string.error_message_network_offline);
        }
        if (e instanceof JsonParseException || e instanceof RetrofitError) {
            return this.mContext.getString(R.string.error_message_parse_response);
        }
        if (e instanceof IOException) {
            return this.mContext.getString(R.string.error_message_general_io);
        }
        return defaultMessage != null ? defaultMessage : this.mContext.getString(R.string.error_message_default);
    }

    private static boolean isCausedByTimeout(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause == e) {
            return false;
        }
        return Errors.isCausedByTimeout(cause);
    }
}

