/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import org.iqnect.iqkit.ui.widget.SwipeDismissListViewTouchListener$$Lambda$1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwipeDismissListViewTouchListener
implements View.OnTouchListener {
    private static final Logger log = LoggerFactory.getLogger(SwipeDismissListViewTouchListener.class);
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private ListView mListView;
    private DismissCallbacks mCallbacks;
    private int mViewWidth = 1;
    private PendingDismissData mPendingDismiss;
    private int mDismissAnimationRefCount = 0;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private VelocityTracker mVelocityTracker;
    private int mDownPosition;
    private View mDownView;
    private boolean mPaused;

    public SwipeDismissListViewTouchListener(ListView listView, DismissCallbacks callbacks) {
        ViewConfiguration vc = ViewConfiguration.get((Context)listView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = listView.getContext().getResources().getInteger(0x10E0000);
        this.mListView = listView;
        this.mCallbacks = callbacks;
    }

    public void setEnabled(boolean enabled) {
        this.mPaused = !enabled;
    }

    public AbsListView.OnScrollListener makeScrollListener() {
        return new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                SwipeDismissListViewTouchListener.this.setEnabled(scrollState != 1);
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        };
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                if (this.mPaused) {
                    return false;
                }
                Rect rect = new Rect();
                int childCount = this.mListView.getChildCount();
                int[] listViewCoords = new int[2];
                this.mListView.getLocationOnScreen(listViewCoords);
                int x = (int)motionEvent.getRawX() - listViewCoords[0];
                int y = (int)motionEvent.getRawY() - listViewCoords[1];
                for (int i = 0; i < childCount; ++i) {
                    View child = this.mListView.getChildAt(i);
                    child.getHitRect(rect);
                    if (!rect.contains(x, y)) continue;
                    this.mDownView = child;
                    break;
                }
                if (this.mDownView != null) {
                    this.mDownX = motionEvent.getRawX();
                    this.mDownY = motionEvent.getRawY();
                    this.mDownPosition = this.mListView.getPositionForView(this.mDownView);
                    if (this.mCallbacks.canDismiss(this.mDownPosition)) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                        this.mVelocityTracker.addMovement(motionEvent);
                    } else {
                        this.mDownView = null;
                    }
                }
                return false;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                if (this.mDownView != null && this.mSwiping) {
                    this.mDownView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mDownView = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float deltaX = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = this.mVelocityTracker.getXVelocity();
                float absVelocityX = Math.abs(velocityX);
                float absVelocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                boolean dismissRight = false;
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= absVelocityX && absVelocityX <= (float)this.mMaxFlingVelocity && absVelocityY < absVelocityX && this.mSwiping) {
                    dismiss = velocityX < 0.0f == deltaX < 0.0f;
                    boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (dismiss && this.mDownPosition != -1) {
                    final View downView = this.mDownView;
                    final int downPosition = this.mDownPosition;
                    ++this.mDismissAnimationRefCount;
                    this.mDownView.animate().translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDismissListViewTouchListener.this.performDismiss(downView, downPosition);
                        }
                    });
                } else {
                    this.mDownView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mDownView = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mPaused || this.mDismissAnimationRefCount != 0) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                if (Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaY) < Math.abs(deltaX) / 2.0f) {
                    this.mSwiping = true;
                    this.mSwipingSlop = deltaX > 0.0f ? this.mSlop : -this.mSlop;
                    this.mListView.requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mListView.onTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                if (!this.mSwiping) break;
                this.mDownView.setTranslationX(deltaX - (float)this.mSwipingSlop);
                this.mDownView.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    private void performDismiss(View dismissView, int dismissPosition) {
        ViewGroup.LayoutParams lp = dismissView.getLayoutParams();
        final int originalHeight = dismissView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                --SwipeDismissListViewTouchListener.this.mDismissAnimationRefCount;
                if (SwipeDismissListViewTouchListener.this.mDismissAnimationRefCount == 0) {
                    SwipeDismissListViewTouchListener.this.mCallbacks.onDismiss(SwipeDismissListViewTouchListener.this.mListView, ((SwipeDismissListViewTouchListener)SwipeDismissListViewTouchListener.this).mPendingDismiss.position);
                    SwipeDismissListViewTouchListener.this.mDownPosition = -1;
                    if (SwipeDismissListViewTouchListener.this.mPendingDismiss != null) {
                        ((SwipeDismissListViewTouchListener)SwipeDismissListViewTouchListener.this).mPendingDismiss.view.setAlpha(1.0f);
                        ((SwipeDismissListViewTouchListener)SwipeDismissListViewTouchListener.this).mPendingDismiss.view.setTranslationX(0.0f);
                        ViewGroup.LayoutParams lp = ((SwipeDismissListViewTouchListener)SwipeDismissListViewTouchListener.this).mPendingDismiss.view.getLayoutParams();
                        lp.height = originalHeight;
                        ((SwipeDismissListViewTouchListener)SwipeDismissListViewTouchListener.this).mPendingDismiss.view.setLayoutParams(lp);
                    }
                    long time = SystemClock.uptimeMillis();
                    MotionEvent cancelEvent = MotionEvent.obtain((long)time, (long)time, (int)3, (float)0.0f, (float)0.0f, (int)0);
                    SwipeDismissListViewTouchListener.this.mListView.dispatchTouchEvent(cancelEvent);
                    SwipeDismissListViewTouchListener.this.mPendingDismiss = null;
                }
            }
        });
        animator.addUpdateListener(SwipeDismissListViewTouchListener$$Lambda$1.lambdaFactory$(lp, dismissView));
        this.mPendingDismiss = new PendingDismissData(dismissPosition, dismissView);
        animator.start();
    }

    static /* synthetic */ void lambda$performDismiss$0(ViewGroup.LayoutParams lp, View dismissView, ValueAnimator valueAnimator) {
        lp.height = (Integer)valueAnimator.getAnimatedValue();
        dismissView.setLayoutParams(lp);
    }

    class PendingDismissData
    implements Comparable<PendingDismissData> {
        public int position;
        public View view;

        public PendingDismissData(int position, View view) {
            this.position = position;
            this.view = view;
        }

        @Override
        public int compareTo(@NonNull PendingDismissData other) {
            return other.position - this.position;
        }
    }

    public static interface DismissCallbacks {
        public boolean canDismiss(int var1);

        public void onDismiss(ListView var1, int var2);
    }
}

