/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import lombok.NonNull;

public abstract class OnSwipeTouchListener
implements View.OnTouchListener {
    @NonNull
    private final GestureDetector mGestureDetector;

    public OnSwipeTouchListener(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public abstract void onSwipeRight();

    public abstract void onSwipeLeft();

    public abstract void onSwipeUp();

    public abstract void onSwipeDown();

    public boolean onTouch(View v, MotionEvent event) {
        return this.mGestureDetector.onTouchEvent(event);
    }

    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_THRESHOLD = 100;
        private static final int SWIPE_VELOCITY_THRESHOLD = 100;

        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            boolean result = false;
            try {
                float diffY = e2.getY() - e1.getY();
                float diffX = e2.getX() - e1.getX();
                if (Math.abs(diffX) > Math.abs(diffY)) {
                    if (Math.abs(diffX) > 100.0f && Math.abs(velocityX) > 100.0f) {
                        if (diffX > 0.0f) {
                            OnSwipeTouchListener.this.onSwipeRight();
                        } else {
                            OnSwipeTouchListener.this.onSwipeLeft();
                        }
                    }
                    result = true;
                } else if (Math.abs(diffY) > 100.0f && Math.abs(velocityY) > 100.0f) {
                    if (diffY > 0.0f) {
                        OnSwipeTouchListener.this.onSwipeDown();
                    } else {
                        OnSwipeTouchListener.this.onSwipeUp();
                    }
                }
                result = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return result;
        }
    }
}

