/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.web.WebActivity;

public class IQTextView
extends TextView {
    private static final String LEGAL = "legal";

    public IQTextView(Context context) {
        this(context, null);
    }

    public IQTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IQTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.checkAttributes(context, attrs);
    }

    private void checkAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IqTextView);
        int htmlTextId = a.getResourceId(R.styleable.IqTextView_textHtml, 0);
        if (htmlTextId > 0) {
            this.setTextViewHtml(htmlTextId);
        }
        a.recycle();
    }

    private void applyUrlListener(@NonNull Spannable strBuilder, final @NonNull URLSpan span) {
        int start = strBuilder.getSpanStart((Object)span);
        int end = strBuilder.getSpanEnd((Object)span);
        int flags = strBuilder.getSpanFlags((Object)span);
        strBuilder.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (IQTextView.LEGAL.equalsIgnoreCase(span.getURL())) {
                    WebActivity.startLegal(IQTextView.this.getContext());
                }
            }
        }, start, end, flags);
        strBuilder.removeSpan((Object)span);
    }

    public void setTextViewHtml(@StringRes int htmlStringResId) {
        this.setTextViewHtml(this.getContext().getString(htmlStringResId));
    }

    public void setTextViewHtml(@NonNull String htmlString) {
        URLSpan[] urls;
        Spanned sequence = Html.fromHtml((String)htmlString);
        SpannableStringBuilder strBuilder = new SpannableStringBuilder((CharSequence)sequence);
        for (URLSpan span : urls = (URLSpan[])strBuilder.getSpans(0, sequence.length(), URLSpan.class)) {
            this.applyUrlListener((Spannable)strBuilder, span);
        }
        this.setText((CharSequence)strBuilder);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }
}

