/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import org.iqnect.iqkit.ui.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAspectRatioFrameLayout
extends FrameLayout {
    private static final Logger log = LoggerFactory.getLogger(FixedAspectRatioFrameLayout.class);
    private int mAspectRatioWidth;
    private int mAspectRatioHeight;

    public FixedAspectRatioFrameLayout(Context context) {
        super(context);
    }

    public FixedAspectRatioFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FixedAspectRatioFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FixedAspectRatioFrameLayout);
        this.mAspectRatioWidth = a.getInt(R.styleable.FixedAspectRatioFrameLayout_aspectRatioWidth, 4);
        this.mAspectRatioHeight = a.getInt(R.styleable.FixedAspectRatioFrameLayout_aspectRatioHeight, 3);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int originalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int finalWidth = View.MeasureSpec.getMode((int)widthMeasureSpec) == 0 ? 100 : originalWidth;
        if (finalWidth < this.getSuggestedMinimumWidth()) {
            finalWidth = this.getSuggestedMinimumWidth();
        }
        int finalHeight = finalWidth * this.mAspectRatioHeight / this.mAspectRatioWidth;
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)finalWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)finalHeight, (int)0x40000000));
    }
}

