/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.support.annotation.NonNull;
import android.text.InputFilter;
import android.text.Spanned;

public class EmojiInputFilter
extends InputFilter.LengthFilter {
    private static final int EMOJI_LOW_BLOCK_START = 8352;
    private static final int EMOJI_LOW_BLOCK_END = 11263;
    private static final int EMOJI_HIGH_BLOCK_START = 126976;
    private static final int EMOJI_HIGH_BLOCK_END = 131071;

    public EmojiInputFilter() {
        this(Integer.MAX_VALUE);
    }

    public EmojiInputFilter(int maxLength) {
        super(maxLength);
    }

    public CharSequence filter(@NonNull CharSequence source, int start, int end, @NonNull Spanned destination, int dStart, int dEnd) {
        for (int i = start; i < end; ++i) {
            if (!EmojiInputFilter.containsEmoji(source, i, end)) continue;
            return "";
        }
        return super.filter(source, start, end, destination, dStart, dEnd);
    }

    private static boolean containsEmoji(@NonNull CharSequence seq, int index, int end) {
        if (index < end) {
            char c1;
            if ((c1 = seq.charAt(index++)) < '\u20a0') {
                return false;
            }
            if (c1 < '\ud800' || c1 > '\udfff') {
                return EmojiInputFilter.isEmoji(c1);
            }
            if (c1 <= '\udbff') {
                if (index == end) {
                    return EmojiInputFilter.isEmoji(-c1);
                }
                char c2 = seq.charAt(index);
                if (Character.isLowSurrogate(c2)) {
                    return EmojiInputFilter.isEmoji(Character.toCodePoint(c1, c2));
                }
            }
        }
        return false;
    }

    private static boolean isEmoji(int codePoint) {
        if (codePoint < 8352 || codePoint > 131071) {
            return false;
        }
        if (codePoint <= 11263) {
            return true;
        }
        return codePoint >= 126976;
    }
}

