/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import lombok.NonNull;
import org.iqnect.iqkit.ui.R;

public final class ColorView
extends FrameLayout {
    @NonNull
    private final Paint mColorPaint = new Paint(1);
    @NonNull
    private final Paint mBorderPaint = new Paint(1);
    @NonNull
    private final RectF mColorRect = new RectF();
    @Px
    private final int mBorderWidth;
    private float mColorRadius;
    @ColorInt
    private int mColor = 0;

    public ColorView(@NonNull Context context) {
        this(context, null);
        if (context == null) {
            throw new NullPointerException("context");
        }
    }

    public ColorView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        if (context == null) {
            throw new NullPointerException("context");
        }
    }

    public ColorView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (context == null) {
            throw new NullPointerException("context");
        }
        Resources res = context.getResources();
        this.mBorderWidth = res.getDimensionPixelSize(R.dimen.color_view_border_width);
        this.mColorPaint.setStyle(Paint.Style.FILL);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-7829368);
        this.setWillNotDraw(false);
        this.setColor(-1);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int availableWidth = w - this.getPaddingLeft() - this.getPaddingRight() - this.mBorderWidth;
        int availableHeight = h - this.getPaddingTop() - this.getPaddingBottom() - this.mBorderWidth;
        this.mColorRadius = availableWidth > availableHeight ? availableHeight / 2 : availableWidth / 2;
        int centerX = w / 2;
        int centerY = h / 2;
        this.mColorRect.set((float)centerX - this.mColorRadius, (float)centerY - this.mColorRadius, (float)centerX + this.mColorRadius, (float)centerY + this.mColorRadius);
        this.invalidate();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawRoundRect(this.mColorRect, this.mColorRadius, this.mColorRadius, this.mColorPaint);
        canvas.drawRoundRect(this.mColorRect, this.mColorRadius, this.mColorRadius, this.mBorderPaint);
    }

    public void setColor(@ColorInt int color2) {
        if (this.mColor != color2) {
            this.mColorPaint.setColor(color2);
            this.invalidate();
        }
    }

    public int getMColor() {
        return this.mColor;
    }
}

