/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.webkit;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.URLUtil;
import android.webkit.WebChromeClient;
import java.util.Map;
import org.iqnect.iqkit.ui.webkit.IqWebChromeClient;
import org.iqnect.iqkit.ui.webkit.IqWebView$$Lambda$1;
import org.iqnect.iqkit.ui.webkit.IqWebView$JavascriptInterface$$Lambda$1;
import org.iqnect.iqkit.ui.webkit.WebViewCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IqWebView
extends WebViewCompat {
    private static final Logger log = LoggerFactory.getLogger(IqWebView.class);
    @Nullable
    private IqWebChromeClient mIqWebChromeClient;
    private boolean addedJavascriptInterface = false;

    public IqWebView(Context context) {
        super(context);
    }

    public IqWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IqWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean isVideoFullscreen() {
        return this.mIqWebChromeClient != null && this.mIqWebChromeClient.isVideoFullscreen();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setWebChromeClient(@Nullable WebChromeClient client) {
        this.getSettings().setJavaScriptEnabled(true);
        if (client instanceof IqWebChromeClient) {
            this.mIqWebChromeClient = (IqWebChromeClient)client;
        }
        super.setWebChromeClient(client);
    }

    public boolean canGoBack() {
        return super.canGoBack() || this.isVideoFullscreen();
    }

    public void goBack() {
        if (this.mIqWebChromeClient == null || !this.mIqWebChromeClient.onBackPressed()) {
            super.goBack();
        }
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.addJavascriptInterface();
        super.loadData(data, mimeType, encoding);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.addJavascriptInterface();
        super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    public void loadUrl(String url) {
        this.addJavascriptInterface();
        super.loadUrl(url);
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.addJavascriptInterface();
        super.loadUrl(url, additionalHttpHeaders);
    }

    public void useDownloadManager(boolean enable) {
        if (enable) {
            this.setDownloadListener(IqWebView$$Lambda$1.lambdaFactory$(this));
        } else {
            this.setDownloadListener(null);
        }
    }

    private void handleDownload(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        try {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, URLUtil.guessFileName((String)url, (String)contentDisposition, (String)mimetype));
            DownloadManager dm = (DownloadManager)this.getContext().getSystemService("download");
            dm.enqueue(request);
        }
        catch (IllegalArgumentException | SecurityException e) {
            log.error("error downloading file: {}", (Object)url, (Object)e);
        }
    }

    private void addJavascriptInterface() {
        if (!this.addedJavascriptInterface) {
            this.addJavascriptInterface(new JavascriptInterface(), "_VideoEnabledWebView");
            this.addedJavascriptInterface = true;
        }
    }

    static /* synthetic */ void access$lambda$0(IqWebView iqWebView, String string2, String string3, String string4, String string5, long l) {
        iqWebView.handleDownload(string2, string3, string4, string5, l);
    }

    public class JavascriptInterface {
        @android.webkit.JavascriptInterface
        public void notifyVideoEnd() {
            Log.d((String)"___", (String)"GOT IT");
            new Handler(Looper.getMainLooper()).post(IqWebView$JavascriptInterface$$Lambda$1.lambdaFactory$(this));
        }

        /* synthetic */ void lambda$notifyVideoEnd$0() {
            if (IqWebView.this.mIqWebChromeClient != null) {
                IqWebView.this.mIqWebChromeClient.onHideCustomView();
            }
        }
    }
}

