/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.web;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import butterknife.BindView;
import javax.inject.Inject;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.uri.UriHandler;
import org.iqnect.iqkit.ui.web.WebActivity$$Lambda$1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class WebActivity
extends BaseActivity {
    private static final Logger log = LoggerFactory.getLogger(WebActivity.class);
    private static final String EXTRA_TITLE = "title";
    private static final String EXTRA_FORCE_FULLSCREEN = "force_fullscreen";
    private static final Uri LEGAL_URI = Uri.parse((String)"http://trigger.iqnect.org/app_iqnect/legal.php");
    @Nullable
    WebView mWebView;
    @BindView(value=2131689677)
    ViewGroup mWebViewContainer;
    @Inject
    UriHandler mUriHandler;
    @BindView(value=2131689674)
    TextView mTitleView;
    @BindView(value=2131689673)
    ImageView mBackImg;
    @BindView(value=2131689676)
    public Toolbar mToolbar;
    @BindView(value=2131689675)
    public ImageView mToolbarBg;
    private boolean mViewInitialised = false;

    public static Intent getIntent(@NonNull Context context, @Nullable String title, @NonNull Uri uri, boolean fullscreen) {
        Intent intent = new Intent(context, WebActivity.class);
        if (title != null) {
            intent.putExtra(EXTRA_TITLE, title);
        }
        intent.putExtra(EXTRA_FORCE_FULLSCREEN, fullscreen);
        intent.setData(uri);
        return intent;
    }

    public static void start(@NonNull Context context, @Nullable String title, @NonNull Uri uri) {
        context.startActivity(WebActivity.getIntent(context, title, uri, false));
    }

    public static void startLegal(@NonNull Context context) {
        WebActivity.start(context, context.getString(R.string.legal), LEGAL_URI);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setProgressBarVisibility(true);
        this.setContentView(this.getLayoutResource());
        this.getActivityComponent().inject(this);
    }

    @LayoutRes
    protected int getLayoutResource() {
        return R.layout.web_activity;
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        if (this.mViewInitialised) {
            return;
        }
        Intent intent = this.getIntent();
        if (intent != null) {
            boolean fullscreen = intent.getBooleanExtra(EXTRA_FORCE_FULLSCREEN, false);
            if (fullscreen) {
                this.toggleFullScreenNoActionBar(true);
                this.mToolbar.setVisibility(8);
                this.mToolbarBg.setVisibility(8);
            } else {
                String title = intent.getStringExtra(EXTRA_TITLE);
                this.mTitleView.setText((CharSequence)title);
                this.mToolbar.setVisibility(0);
                this.mToolbarBg.setVisibility(0);
            }
        }
        this.mBackImg.setOnClickListener(WebActivity$$Lambda$1.lambdaFactory$(this));
        this.mWebView = new WebView(this.getApplicationContext());
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mWebViewContainer.addView((View)this.mWebView);
        WebSettings settings = this.mWebView.getSettings();
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setAppCacheEnabled(true);
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(false);
        settings.setJavaScriptEnabled(true);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                int val = Math.round(newProgress * 100);
                WebActivity.this.setProgress(val);
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                log.info("show custom view: {}", (Object)view);
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return WebActivity.this.tryHandleUri(url) || super.shouldOverrideUrlLoading(view, url);
            }
        });
        this.mWebView.loadUrl(this.getIntent().getData().toString());
        this.mViewInitialised = true;
    }

    public void onBackPressed() {
        if (this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (this.mWebView != null) {
            this.mWebView.onPause();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.onResume();
        }
    }

    @Override
    protected void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.setWebChromeClient(null);
            this.mWebView.setWebViewClient(null);
            this.mWebView.destroy();
        }
        this.mWebViewContainer.removeAllViews();
        super.onDestroy();
    }

    private boolean tryHandleUri(@Nullable String uri) {
        log.debug("try handle uri: {}", (Object)uri);
        return this.mUriHandler.handleUri((Context)this, Uri.parse((String)uri));
    }

    /* synthetic */ void lambda$onContentChanged$0(View view) {
        this.finish();
    }
}

