/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.iqnect.iqkit.ui.util.BaseAnimationListener;

public class ViewExpander {
    private static final long DEFAULT_DURATION = 250L;
    private final View mView;
    private long mDuration = 250L;
    private boolean mAnimating;
    private boolean mExpanded;
    private OnSizeChangedListener mOnSizeChangedListener;

    public ViewExpander(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("view");
        }
        this.mView = view;
    }

    @Nullable
    public OnSizeChangedListener getOnSizeChangedListener() {
        return this.mOnSizeChangedListener;
    }

    public void setOnSizeChangedListener(@Nullable OnSizeChangedListener onSizeChangedListener) {
        this.mOnSizeChangedListener = onSizeChangedListener;
    }

    public boolean isAnimating() {
        return this.mAnimating;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public void setExpanded(boolean expanded, boolean animated) {
        if (!this.mAnimating && expanded != this.mExpanded) {
            this.mExpanded = expanded;
            if (expanded) {
                this.expand(animated);
            } else {
                this.contract(animated);
            }
        }
    }

    private void expand(boolean animated) {
        final ViewGroup.LayoutParams params = this.mView.getLayoutParams();
        this.mView.setVisibility(0);
        this.mView.measure(-1, 0);
        final int endHeight = this.mView.getMeasuredHeight();
        if (animated) {
            params.height = 0;
            this.mView.requestLayout();
            Animation anim = new Animation(){

                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    int interpolatedHeight = (int)(interpolatedTime * (float)endHeight);
                    params.height = interpolatedTime < 1.0f ? interpolatedHeight : -2;
                    ViewExpander.this.dispatchSizeChanged(ViewExpander.this.mView.getWidth(), interpolatedHeight);
                    ViewExpander.this.mView.requestLayout();
                }

                public boolean willChangeBounds() {
                    return true;
                }
            };
            anim.setDuration(this.mDuration);
            anim.setAnimationListener((Animation.AnimationListener)new BaseAnimationListener(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    ViewExpander.this.mAnimating = false;
                }
            });
            this.mAnimating = true;
            this.mView.startAnimation(anim);
        } else {
            params.height = -2;
            this.mView.requestLayout();
            this.dispatchSizeChanged(this.mView.getWidth(), endHeight);
        }
    }

    private void contract(boolean animated) {
        final ViewGroup.LayoutParams params = this.mView.getLayoutParams();
        if (animated) {
            final int initialHeight = this.mView.getMeasuredHeight();
            Animation anim = new Animation(){

                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    int interpolatedHeight;
                    params.height = interpolatedHeight = (int)((float)initialHeight - interpolatedTime * (float)initialHeight);
                    ViewExpander.this.dispatchSizeChanged(ViewExpander.this.mView.getWidth(), interpolatedHeight);
                    ViewExpander.this.mView.requestLayout();
                }

                public boolean willChangeBounds() {
                    return true;
                }
            };
            anim.setDuration(this.mDuration);
            anim.setAnimationListener((Animation.AnimationListener)new BaseAnimationListener(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    ViewExpander.this.mView.setVisibility(8);
                    ViewExpander.this.mAnimating = false;
                }
            });
            this.mAnimating = true;
            this.mView.startAnimation(anim);
        } else {
            this.mView.setVisibility(8);
            this.dispatchSizeChanged(this.mView.getWidth(), 0);
        }
    }

    private void dispatchSizeChanged(int width, int height) {
        if (this.mOnSizeChangedListener != null) {
            this.mOnSizeChangedListener.onSizeChanged(width, height);
        }
    }

    public static interface OnSizeChangedListener {
        public void onSizeChanged(int var1, int var2);
    }
}

