/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import lombok.NonNull;

public class PreferenceUtils {
    public static final String PREF_SHOWN_HINTS = "shown_hints";
    public static final String PREF_USER_SKIP = "user_skip";

    public static void writeBooleanPreference(@NonNull Context context, @NonNull String key, boolean value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        SharedPreferences.Editor editor = PreferenceUtils.getPrefsEditor(context);
        editor.putBoolean(key, value).apply();
    }

    public static boolean readBooleanPreference(@NonNull Context context, @NonNull String key) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        SharedPreferences sharedPreferences = PreferenceUtils.getDefaultSharedPreference(context);
        return sharedPreferences.getBoolean(key, false);
    }

    @NonNull
    private static SharedPreferences getDefaultSharedPreference(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    @NonNull
    private static SharedPreferences.Editor getPrefsEditor(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return PreferenceUtils.getDefaultSharedPreference(context).edit();
    }
}

