/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.io.File;

public final class FileUtils {
    private static final String HUMAN_READABLE_BYTES_FORMAT = "%.2f%sB";
    private static final String HUMAN_READABLE_BYTES_UNIT = "KMGTPE";
    private static final int BYTES_UNIT_MULTIPLIER = 1024;

    private FileUtils() {
        throw new AssertionError((Object)"No instances.");
    }

    @NonNull
    public static String humanReadableByteCount(@NonNull Uri uri) {
        return FileUtils.humanReadableByteCount(uri.getPath());
    }

    @NonNull
    public static String humanReadableByteCount(@NonNull String path) {
        return FileUtils.humanReadableByteCount(new File(path));
    }

    @NonNull
    public static String humanReadableByteCount(@NonNull File file) {
        return FileUtils.humanReadableByteCount(file.exists() ? file.length() : 0L);
    }

    @SuppressLint(value={"DefaultLocale"})
    @NonNull
    public static String humanReadableByteCount(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        char pre = HUMAN_READABLE_BYTES_UNIT.charAt(exp - 1);
        return String.format(HUMAN_READABLE_BYTES_FORMAT, (double)bytes / Math.pow(1024.0, exp), Character.valueOf(pre));
    }
}

