/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.os.PowerManager;
import android.os.ResultReceiver;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import lombok.NonNull;
import net.sf.oval.internal.util.ReflectionUtils;
import org.iqnect.iqkit.ui.R;

public class DeviceUtils {
    @Nullable
    private static final Method IMM_HIDE_SOFT_INPUT = ReflectionUtils.getMethod(InputMethodManager.class, (String)"closeCurrentInput", (Class[])new Class[0]);
    @Nullable
    private static final Method IMM_SHOW_SOFT_INPUT = ReflectionUtils.getMethod(InputMethodManager.class, (String)"showSoftInputUnchecked", (Class[])new Class[]{Integer.TYPE, ResultReceiver.class});

    private DeviceUtils() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void tryShowSoftInput(@NonNull Context context, @Nullable View view) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (IMM_SHOW_SOFT_INPUT != null) {
            try {
                IMM_SHOW_SOFT_INPUT.setAccessible(true);
                IMM_SHOW_SOFT_INPUT.invoke((Object)imm, 0, null);
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (view != null) {
            imm.showSoftInput(view, 0);
        }
    }

    public static void tryHideSoftInput(@NonNull Context context, @Nullable View currentFocus) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (currentFocus != null) {
            currentFocus.clearFocus();
        }
        if (IMM_HIDE_SOFT_INPUT != null) {
            try {
                IMM_HIDE_SOFT_INPUT.setAccessible(true);
                IMM_HIDE_SOFT_INPUT.invoke((Object)imm, new Object[0]);
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (currentFocus != null) {
            imm.hideSoftInputFromWindow(currentFocus.getWindowToken(), 1);
        }
    }

    @NonNull
    public static Point getDisplaySize(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point p = new Point();
        display.getRealSize(p);
        return p;
    }

    public static int getStatusBarHeight(@NonNull Context context) {
        Resources res;
        if (context == null) {
            throw new NullPointerException("context");
        }
        boolean result = false;
        int resourceId = (res = context.getResources()).getIdentifier("status_bar_height", "dimen", "android");
        return res.getDimensionPixelSize(resourceId > 0 ? resourceId : R.dimen.status_bar_height);
    }

    public static boolean isEmulator() {
        return Build.PRODUCT.equals("Genymotion") || Build.PRODUCT.equals("sdk") || Build.PRODUCT.equals("sdk_x86") || Build.DISPLAY.contains("vbox86p");
    }

    public static boolean isScreenOn(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 20) {
            return pm.isInteractive();
        }
        return pm.isScreenOn();
    }

    @NonNull
    public static String getCountryCodeLowerCase(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            String simCountry = telephonyManager.getSimCountryIso();
            if (!TextUtils.isEmpty((CharSequence)simCountry)) {
                return simCountry.toLowerCase();
            }
            String networkCountry = telephonyManager.getNetworkCountryIso();
            if (!TextUtils.isEmpty((CharSequence)networkCountry)) {
                return networkCountry.toLowerCase();
            }
        }
        return Locale.getDefault().getCountry();
    }
}

