/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.uri;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.iqnect.iqkit.analytics.AnalyticsProxy;
import org.iqnect.iqkit.model.Event;
import org.iqnect.iqkit.ui.app.SearchResultActivity;
import org.iqnect.iqkit.ui.uri.BaseInstructionHandler;
import org.iqnect.iqkit.ui.uri.Instruction;
import org.iqnect.iqkit.ui.uri.InstructionChain;
import org.iqnect.iqkit.ui.uri.InstructionHandler;
import org.iqnect.iqkit.ui.uri.InstructionHandlerCallback;
import org.iqnect.iqkit.ui.uri.UriHandler$3$$Lambda$1;
import org.iqnect.iqkit.ui.web.WebActivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriHandler {
    private static final Logger log = LoggerFactory.getLogger(UriHandler.class);
    private static final String SCHEME = "iqnect";
    private Collection<InstructionHandler> mInstructionHandlers = new ArrayList<InstructionHandler>();
    private InstructionHandler mFullScreenInstructionHandler = new BaseInstructionHandler("fullscreen"){

        @Override
        public Intent getIntent(Context context, Instruction instruction) {
            return UriHandler.this.fullscreenIntent(context, Uri.parse((String)instruction.getParam()));
        }
    };
    private InstructionHandler mSearchInstructionHandler = new BaseInstructionHandler("iq"){

        @Override
        public boolean canHandleInstruction(Instruction instruction) {
            return instruction.getMethod().equals("iq") || instruction.getMethod().equals("url");
        }

        @Override
        public Intent getIntent(Context context, Instruction instruction) {
            return null;
        }
    };
    private AnalyticsProxy mAnalyticsProxy;

    @Inject
    public UriHandler(AnalyticsProxy proxy, Gson gson) {
        this.mAnalyticsProxy = proxy;
        this.registerInstructionHandler(this.mFullScreenInstructionHandler);
        this.registerInstructionHandler(this.mSearchInstructionHandler);
    }

    public boolean handleUri(@NonNull Context context, @NonNull Uri uri) {
        log.debug("handleUri:uri={}", (Object)uri.toString());
        if (SCHEME.equalsIgnoreCase(uri.getScheme())) {
            InstructionChain chain = new InstructionChain(uri);
            this.executeChain(context, chain);
            return true;
        }
        Intent intent = this.getNonIqnectIntent(context, uri);
        if (intent != null) {
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    private void executeChain(final @NonNull Context context, final @NonNull InstructionChain chain) {
        final Instruction instruction = chain.first();
        InstructionHandler handler = this.getHandler(instruction);
        if (instruction == null || handler == null) {
            return;
        }
        log.debug("executing instruction: {}", (Object)instruction);
        handler.handleInstruction(context, instruction, new InstructionHandlerCallback(){

            @Override
            public void onSuccess() {
                log.debug("instruction handler: onSuccess");
                UriHandler.this.analyticsEvent(Event.Category.IQNECT_UI_URL, instruction.getMethod(), instruction.getParam());
                chain.getInstructions().pollFirst();
                if (chain.getInstructions().size() == 0) {
                    this.finish();
                } else {
                    new Handler(Looper.getMainLooper()).post(UriHandler$3$$Lambda$1.lambdaFactory$(this, context, chain));
                }
            }

            @Override
            public void onCancel() {
                log.debug("instruction handler: onCancel");
                this.finish();
            }

            @Override
            public void onError(Exception e) {
                log.error("instruction handler: onError", (Throwable)e);
                this.finish();
            }

            private void finish() {
                log.debug("chain finished executing: {}", (Object)chain);
            }

            /* synthetic */ void lambda$onSuccess$0(@NonNull Context context2, @NonNull InstructionChain chain2) {
                UriHandler.this.executeChain(context2, chain2);
            }
        });
    }

    private InstructionHandler getHandler(Instruction instruction) {
        if (instruction == null) {
            return null;
        }
        for (InstructionHandler handler : this.mInstructionHandlers) {
            if (!handler.canHandleInstruction(instruction)) continue;
            return handler;
        }
        log.debug("no handler for instruction: {}", (Object)instruction);
        return null;
    }

    public Intent getIntent(@NonNull Context context, @NonNull Uri uri) {
        if (SCHEME.equalsIgnoreCase(uri.getScheme())) {
            InstructionChain chain = new InstructionChain(uri);
            Instruction instruction = chain.first();
            InstructionHandler handler = this.getHandler(instruction);
            return handler == null ? null : handler.getIntent(context, instruction);
        }
        return this.getNonIqnectIntent(context, uri);
    }

    private Intent getNonIqnectIntent(@NonNull Context context, @NonNull Uri uri) {
        if (uri.toString().startsWith("http://embed.wirewax.com")) {
            log.debug("full screen uri: {}", (Object)uri);
            return this.fullscreenIntent(context, uri);
        }
        if (this.isViewableProtocol(uri)) {
            log.debug("viewable uri: {}", (Object)uri);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(uri);
            return intent;
        }
        if (uri.toString().startsWith("http://player.wirewax.com/appGo.php")) {
            log.debug("wirewax info uri: {}", (Object)uri);
            return SearchResultActivity.getWebFragmentIntent(context, uri);
        }
        return null;
    }

    public void registerInstructionHandler(InstructionHandler handler) {
        this.mInstructionHandlers.add(handler);
    }

    private boolean isViewableProtocol(Uri uri) {
        String url = uri.toString();
        return url.startsWith("market://") || url.startsWith("tel:") || url.startsWith("mailto:");
    }

    @Nullable
    private Intent fullscreenIntent(Context context, Uri uri) {
        return WebActivity.getIntent(context, null, uri, true);
    }

    public void analyticsEvent(Event.Category category, Event.Action action) {
        this.mAnalyticsProxy.analyticsEvent(category, action);
    }

    public void analyticsEvent(Event.Category category, Event.Action action, String label) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label);
    }

    public void analyticsEvent(Event.Category category, Event.Action action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    public void analyticsEvent(Event.Category category, String action, String label) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label);
    }

    public void analyticsEvent(Event.Category category, String action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }

    public void analyticsEvent(String category, String action, String label, Long value) {
        this.mAnalyticsProxy.analyticsEvent(category, action, label, value);
    }
}

