/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.uri;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.iqnect.iqkit.ui.uri.Instruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionChain {
    private static final Logger log = LoggerFactory.getLogger(InstructionChain.class);
    private static final String UTF_8 = "UTF-8";
    private Uri mUri;
    private LinkedList<Instruction> mInstructions;

    public InstructionChain(Uri uri) {
        this.mUri = uri;
        this.mInstructions = new LinkedList<Instruction>(this.getInstructions(uri));
    }

    public String toString() {
        return this.mUri.toString();
    }

    public Instruction first() {
        return this.mInstructions.size() > 0 ? this.mInstructions.get(0) : null;
    }

    @NonNull
    private Collection<Instruction> getInstructions(@NonNull Uri uri) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        if (uri.getPath().length() < 1) {
            return instructions;
        }
        String query = uri.getEncodedPath().substring(1);
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(query.split("/")));
        parts.add(0, uri.getAuthority());
        log.debug("parts: {}", parts);
        int i = 0;
        while (i + 1 < parts.size()) {
            Instruction instruction = new Instruction((String)parts.get(i), InstructionChain.decodeParam((String)parts.get(i + 1)));
            instructions.add(instruction);
            log.debug("url instruction: {} {}", (Object)instruction.getMethod(), (Object)instruction.getParam());
            i += 2;
        }
        return instructions;
    }

    @Nullable
    private static String decodeParam(String param) {
        try {
            param = URLDecoder.decode(param, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            log.error("charset problem for string {} {}", (Object)param, (Object)e.getMessage());
            return null;
        }
        return param;
    }

    public LinkedList<Instruction> getInstructions() {
        return this.mInstructions;
    }
}

