/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.uri;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.common.base.Objects;
import org.iqnect.iqkit.ui.uri.Instruction;
import org.iqnect.iqkit.ui.uri.InstructionHandler;
import org.iqnect.iqkit.ui.uri.InstructionHandlerCallback;

public abstract class BaseInstructionHandler
implements InstructionHandler {
    @NonNull
    private String mInstructionName;

    public BaseInstructionHandler(@NonNull String instructionName) {
        this.mInstructionName = instructionName;
    }

    @Override
    public boolean canHandleInstruction(@NonNull Instruction instruction) {
        return Objects.equal((Object)instruction.getMethod(), (Object)this.mInstructionName);
    }

    @Override
    public void handleInstruction(@NonNull Context context, Instruction instruction, InstructionHandlerCallback callback) {
        Intent intent = this.getIntent(context, instruction);
        if (intent != null) {
            context.startActivity(intent);
            callback.onSuccess();
        } else {
            callback.onCancel();
        }
    }
}

