/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.opengl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.iqnect.iqkit.ui.opengl.Renderer;

abstract class Shape {
    @NonNull
    private final float[] mModelMatrix = new float[16];
    @NonNull
    private final float[] mTranslation = new float[]{0.0f, 0.0f, 0.0f};
    @NonNull
    private final float[] mScale = new float[]{1.0f, 1.0f, 1.0f};
    @NonNull
    private final float[] mColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    Shape() {
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
    }

    @NonNull
    protected float[] getObjectMatrix(@NonNull float[] mvpMatrix) {
        float[] temp = (float[])this.mModelMatrix.clone();
        Matrix.translateM((float[])temp, (int)0, (float)this.mTranslation[0], (float)this.mTranslation[1], (float)this.mTranslation[2]);
        Matrix.scaleM((float[])temp, (int)0, (float)this.mScale[0], (float)this.mScale[1], (float)this.mScale[2]);
        Matrix.multiplyMM((float[])temp, (int)0, (float[])mvpMatrix, (int)0, (float[])temp, (int)0);
        return temp;
    }

    @NonNull
    float[] getColorMatrix() {
        return this.mColor;
    }

    @NonNull
    public float[] getColor() {
        return Arrays.copyOfRange(this.mColor, 0, 3);
    }

    public void setColor(@NonNull float[] color2) {
        if (color2.length != 3) {
            throw new IllegalArgumentException("color matrix must have exactly 3 values, for RGB");
        }
        System.arraycopy(color2, 0, this.mColor, 0, 3);
    }

    public void setAlpha(float alpha) {
        this.mColor[3] = alpha;
    }

    @NonNull
    public float[] getTranslation() {
        return this.mTranslation;
    }

    public float getTranslationX() {
        return this.mTranslation[0];
    }

    public float getTranslationY() {
        return this.mTranslation[1];
    }

    public float getTranslationZ() {
        return this.mTranslation[2];
    }

    public void setTranslation(float x, float y, float z) {
        this.setTranslationX(x);
        this.setTranslationY(y);
        this.setTranslationZ(z);
    }

    public void setTranslationX(float x) {
        this.mTranslation[0] = x;
    }

    public void setTranslationY(float y) {
        this.mTranslation[1] = y;
    }

    public void setTranslationZ(float z) {
        this.mTranslation[2] = z;
    }

    @NonNull
    public float[] getScale() {
        return this.mScale;
    }

    public float getScaleX() {
        return this.mScale[0];
    }

    public float getScaleY() {
        return this.mScale[1];
    }

    public float getScaleZ() {
        return this.mScale[2];
    }

    public void setScale(float x, float y, float z) {
        this.setScaleX(x);
        this.setScaleY(y);
        this.setScaleZ(z);
    }

    public void setScaleX(float x) {
        this.mScale[0] = x;
    }

    public void setScaleY(float y) {
        this.mScale[1] = y;
    }

    public void setScaleZ(float z) {
        this.mScale[2] = z;
    }

    protected static int createProgram(@NonNull String vertexShader, @NonNull String fragmentShader, Attribute ... attributes) {
        int vertexShaderHandle = Renderer.loadShader(35633, vertexShader);
        int fragmentShaderHandle = Renderer.loadShader(35632, fragmentShader);
        int program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)program, (int)vertexShaderHandle);
        GLES20.glAttachShader((int)program, (int)fragmentShaderHandle);
        for (Attribute attribute : attributes) {
            GLES20.glBindAttribLocation((int)program, (int)attribute.getIndex(), (String)attribute.getName());
        }
        GLES20.glLinkProgram((int)program);
        return program;
    }

    static FloatBuffer generateFloatBuffer(@NonNull float[] array) {
        ByteBuffer bb = ByteBuffer.allocateDirect(array.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(array);
        fb.position(0);
        return fb;
    }

    static ShortBuffer generateShortBuffer(@NonNull short[] array) {
        ByteBuffer bb = ByteBuffer.allocateDirect(array.length * 4);
        bb.order(ByteOrder.nativeOrder());
        ShortBuffer sb = bb.asShortBuffer();
        sb.put(array);
        sb.position(0);
        return sb;
    }

    static class Attribute {
        @NonNull
        private final String mName;
        private final int mIndex;

        Attribute(@NonNull String name, int index) {
            this.mName = name;
            this.mIndex = index;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        public int getIndex() {
            return this.mIndex;
        }
    }

    static abstract class Helper<T extends Shape> {
        Helper() {
        }

        public abstract void preDraw();

        public abstract void render(@NonNull T var1, @NonNull float[] var2);

        public abstract void postDraw();
    }
}

