/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.opengl;

import android.opengl.GLES20;
import android.support.annotation.NonNull;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.iqnect.iqkit.ui.opengl.Shape;

public class Rectangle
extends Shape {
    private static final String VERTEX_SHADER_CODE = "uniform mat4 uMVPMatrix;attribute vec4 vPosition;void main() {  gl_Position = uMVPMatrix * vPosition;}";
    private static final String FRAGMENT_SHADER_CODE = "precision mediump float;uniform vec4 vColor;void main() {  gl_FragColor = vColor;}";
    private static final int COORDS_PER_VERTEX = 3;
    private static final short[] DRAW_ORDER = new short[]{0, 1, 2, 0, 2, 3};
    private static final int VERTEX_STRIDE = 12;

    @NonNull
    private static FloatBuffer createVertexBuffer(float width, float height, float depth) {
        float right = width / 2.0f;
        float left = -right;
        float bottom = height / 2.0f;
        float top = -bottom;
        float[] vertices = new float[]{left, top, depth, left, bottom, depth, right, bottom, depth, right, top, depth};
        return Shape.generateFloatBuffer(vertices);
    }

    @NonNull
    private static ShortBuffer createDrawListBuffer() {
        return Shape.generateShortBuffer(DRAW_ORDER);
    }

    private static void preDraw(int program) {
        GLES20.glUseProgram((int)program);
    }

    private void render(@NonNull float[] mvpMatrix, int program, @NonNull FloatBuffer vertexBuffer, @NonNull ShortBuffer drawListBuffer) {
        float[] objectMatrix = this.getObjectMatrix(mvpMatrix);
        int positionHandle = GLES20.glGetAttribLocation((int)program, (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)vertexBuffer);
        int colorHandle = GLES20.glGetUniformLocation((int)program, (String)"vColor");
        GLES20.glUniform4fv((int)colorHandle, (int)1, (float[])this.getColorMatrix(), (int)0);
        int mvpMatrixHandle = GLES20.glGetUniformLocation((int)program, (String)"uMVPMatrix");
        GLES20.glUniformMatrix4fv((int)mvpMatrixHandle, (int)1, (boolean)false, (float[])objectMatrix, (int)0);
        GLES20.glDrawElements((int)4, (int)DRAW_ORDER.length, (int)5123, (Buffer)drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)positionHandle);
    }

    private static int createProgram() {
        return Rectangle.createProgram(VERTEX_SHADER_CODE, FRAGMENT_SHADER_CODE, new Shape.Attribute[0]);
    }

    static /* synthetic */ int access$000() {
        return Rectangle.createProgram();
    }

    public static class RectangleHelper
    extends Shape.Helper<Rectangle> {
        @NonNull
        private final FloatBuffer mVertexBuffer;
        @NonNull
        private final ShortBuffer mDrawListBuffer;
        private final int mProgram = Rectangle.access$000();

        public RectangleHelper(float width, float height, float depth) {
            this.mDrawListBuffer = Rectangle.createDrawListBuffer();
            this.mVertexBuffer = Rectangle.createVertexBuffer(width, height, depth);
        }

        @Override
        public void preDraw() {
            Rectangle.preDraw(this.mProgram);
        }

        @Override
        public void render(@NonNull Rectangle rectangle, @NonNull float[] mvpMatrix) {
            rectangle.render(mvpMatrix, this.mProgram, this.mVertexBuffer, this.mDrawListBuffer);
        }

        @Override
        public void postDraw() {
        }
    }
}

