/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.opengl;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.iqnect.iqkit.ui.opengl.Shape;

public class BitmapTexture
extends Shape {
    private static final String VERTEX_SHADER_CODE = "attribute vec2 aTexCoordinate;varying vec2 vTexCoordinate;uniform mat4 uMVPMatrix;attribute vec4 vPosition;void main() {  gl_Position = uMVPMatrix * vPosition;  vTexCoordinate = aTexCoordinate;}";
    private static final String FRAGMENT_SHADER_CODE = "precision mediump float;uniform vec4 vColor;uniform sampler2D uTexture;varying vec2 vTexCoordinate;void main() {  gl_FragColor = (vColor * texture2D(uTexture, vTexCoordinate));}";
    private static final int COORDS_PER_VERTEX = 3;
    private static final short[] DRAW_ORDER = new short[]{0, 1, 2, 0, 2, 3};
    private static final int VERTEX_STRIDE = 12;
    private static final int TEXTURE_COORD_DATA_SIZE = 2;
    private static final int TEXTURE_VERTEX_STRIDE = 8;
    @Nullable
    private FloatBuffer mTextureBuffer;
    private int mCurrentFrame;
    private float mCurrentProgress;

    private static FloatBuffer createTextureBuffer() {
        return BitmapTexture.createTextureBuffer(false, false);
    }

    private static FloatBuffer createTextureBuffer(boolean flipHorizontal, boolean flipVertical) {
        float[] vertices = new float[]{flipHorizontal ? 1.0f : 0.0f, flipVertical ? 0.0f : 1.0f, flipHorizontal ? 1.0f : 0.0f, flipVertical ? 1.0f : 0.0f, flipHorizontal ? 0.0f : 1.0f, flipVertical ? 1.0f : 0.0f, flipHorizontal ? 0.0f : 1.0f, flipVertical ? 0.0f : 1.0f};
        return Shape.generateFloatBuffer(vertices);
    }

    private void updateTextureBuffer(int frameCount) {
        float offsetStart = (float)this.mCurrentFrame / (float)frameCount;
        float offsetEnd = (float)(this.mCurrentFrame + 1) / (float)frameCount;
        float[] vertices = new float[]{offsetStart, 1.0f, offsetStart, 0.0f, offsetEnd, 0.0f, offsetEnd, 1.0f};
        this.mTextureBuffer = Shape.generateFloatBuffer(vertices);
    }

    private void bumpFrame(int frameCount) {
        ++this.mCurrentFrame;
        this.mCurrentProgress = (float)this.mCurrentFrame / (float)frameCount;
    }

    @NonNull
    private static FloatBuffer createVertexBuffer(float width, float height, float depth) {
        float right = width / 2.0f;
        float left = -right;
        float bottom = height / 2.0f;
        float top = -bottom;
        float[] vertices = new float[]{left, top, depth, left, bottom, depth, right, bottom, depth, right, top, depth};
        return Shape.generateFloatBuffer(vertices);
    }

    @NonNull
    private static ShortBuffer createDrawListBuffer() {
        return Shape.generateShortBuffer(DRAW_ORDER);
    }

    private static void preDraw(int program) {
        GLES20.glUseProgram((int)program);
    }

    private void render(@NonNull float[] mvpMatrix, int program, @Nullable FloatBuffer textureBuffer, @NonNull FloatBuffer vertexBuffer, @NonNull ShortBuffer drawListBuffer, int textureDataHandle) {
        if (textureBuffer == null) {
            if (this.mTextureBuffer == null) {
                throw new IllegalStateException("must create texture buffer before calling render");
            }
            textureBuffer = this.mTextureBuffer;
        }
        float[] objectMatrix = this.getObjectMatrix(mvpMatrix);
        int positionHandle = GLES20.glGetAttribLocation((int)program, (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)vertexBuffer);
        int colorHandle = GLES20.glGetUniformLocation((int)program, (String)"vColor");
        GLES20.glUniform4fv((int)colorHandle, (int)1, (float[])this.getColorMatrix(), (int)0);
        int textureUniformHandle = GLES20.glGetAttribLocation((int)program, (String)"uTexture");
        int textureCoordinateHandle = GLES20.glGetAttribLocation((int)program, (String)"aTexCoordinate");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureDataHandle);
        GLES20.glUniform1i((int)textureUniformHandle, (int)0);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)textureCoordinateHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)textureCoordinateHandle);
        int mvpMatrixHandle = GLES20.glGetUniformLocation((int)program, (String)"uMVPMatrix");
        GLES20.glUniformMatrix4fv((int)mvpMatrixHandle, (int)1, (boolean)false, (float[])objectMatrix, (int)0);
        GLES20.glDrawElements((int)4, (int)DRAW_ORDER.length, (int)5123, (Buffer)drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)positionHandle);
        GLES20.glDisableVertexAttribArray((int)textureCoordinateHandle);
    }

    private static int loadTexture(@NonNull Bitmap bitmap) {
        int[] textureHandle = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandle, (int)0);
        if (textureHandle[0] != 0) {
            GLES20.glBindTexture((int)3553, (int)textureHandle[0]);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        if (textureHandle[0] == 0) {
            throw new RuntimeException("Error loading texture.");
        }
        return textureHandle[0];
    }

    private static int createProgram() {
        Shape.Attribute attribute = new Shape.Attribute("aTexCoordinate", 0);
        return BitmapTexture.createProgram(VERTEX_SHADER_CODE, FRAGMENT_SHADER_CODE, attribute);
    }

    public int getCurrentFrame() {
        return this.mCurrentFrame;
    }

    public float getCurrentProgress() {
        return this.mCurrentProgress;
    }

    static /* synthetic */ int access$000() {
        return BitmapTexture.createProgram();
    }

    public static class BitmapTextureHelper
    extends Shape.Helper<BitmapTexture> {
        private static final int STATIC_FRAME = -1;
        @Nullable
        private FloatBuffer mTextureBuffer;
        @NonNull
        private final FloatBuffer mVertexBuffer;
        @NonNull
        private final ShortBuffer mDrawListBuffer;
        private final int mProgram = BitmapTexture.access$000();
        private int mTextureDataHandle;
        private int mFrameCount = -1;
        private boolean mSpriteSheet;

        public BitmapTextureHelper(@NonNull Context context, float width, float height, float depth, @DrawableRes int resourceId, boolean isSpriteSheet) {
            this.mVertexBuffer = BitmapTexture.createVertexBuffer(width, height, depth);
            this.mDrawListBuffer = BitmapTexture.createDrawListBuffer();
            this.mSpriteSheet = isSpriteSheet;
            this.loadBitmapTexture(context, resourceId);
        }

        private void loadBitmapTexture(@NonNull Context context, @DrawableRes int resourceId) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inScaled = false;
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId, (BitmapFactory.Options)options);
            if (this.mSpriteSheet) {
                this.mFrameCount = bitmap.getWidth() / bitmap.getHeight();
            } else {
                this.mTextureBuffer = BitmapTexture.createTextureBuffer();
            }
            this.mTextureDataHandle = BitmapTexture.loadTexture(bitmap);
            bitmap.recycle();
        }

        @Override
        public void preDraw() {
            BitmapTexture.preDraw(this.mProgram);
        }

        @Override
        public void render(@NonNull BitmapTexture bitmapTexture, @NonNull float[] mvpMatrix) {
            if (this.mSpriteSheet) {
                bitmapTexture.updateTextureBuffer(this.mFrameCount);
            }
            bitmapTexture.render(mvpMatrix, this.mProgram, this.mTextureBuffer, this.mVertexBuffer, this.mDrawListBuffer, this.mTextureDataHandle);
            if (this.mFrameCount != -1) {
                bitmapTexture.bumpFrame(this.mFrameCount);
            }
        }

        @Override
        public void postDraw() {
        }

        public void reloadTextureBuffer(boolean flipHorizontal, boolean flipVertical) {
            if (this.mSpriteSheet) {
                throw new IllegalStateException("cannot reload texture for spritesheet animation helper");
            }
            this.mTextureBuffer = BitmapTexture.createTextureBuffer(flipHorizontal, flipVertical);
        }

        public int getFrameCount() {
            return this.mFrameCount;
        }

        public void setFrameCount(int mFrameCount) {
            this.mFrameCount = mFrameCount;
        }
    }
}

