/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.injection;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import com.facebook.CallbackManager;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.login.LoginManager;
import dagger.Module;
import dagger.Provides;
import org.iqnect.iqkit.IQKitConfiguration;
import org.iqnect.iqkit.ui.injection.UIScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module
public class FacebookModule {
    private static final Logger log = LoggerFactory.getLogger(FacebookModule.class);

    @Provides
    @UIScope
    LoginManager provideLoginManager(Context context, IQKitConfiguration configuration) {
        this.ensureInitialized(context, configuration);
        return LoginManager.getInstance();
    }

    @Provides
    @UIScope
    CallbackManager provideCallbackManager(Context context, IQKitConfiguration configuration) {
        this.ensureInitialized(context, configuration);
        return CallbackManager.Factory.create();
    }

    private void ensureInitialized(Context context, IQKitConfiguration configuration) {
        if (!FacebookSdk.isInitialized()) {
            FacebookSdk.setApplicationId((String)configuration.getFacebookId());
            FacebookSdk.sdkInitialize((Context)context.getApplicationContext());
            if (context instanceof Activity) {
                context = ((Activity)context).getApplication();
            }
            if (context instanceof Application) {
                AppEventsLogger.activateApp((Application)((Application)context));
            } else {
                AppEventsLogger.activateApp((Context)context);
            }
            log.debug("initialised facebook sdk, app id: {}", (Object)FacebookSdk.getApplicationId());
        }
    }
}

