/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.widget.ShareDialog;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookShareActivity
extends BaseActivity {
    private static final Logger log = LoggerFactory.getLogger(FacebookShareActivity.class);
    private static final String EXTRA_URI = "uri";
    private boolean shownDialog;

    public static Intent getIntent(Context context, Uri url) {
        Intent intent = new Intent(context, FacebookShareActivity.class);
        intent.putExtra(EXTRA_URI, (Parcelable)url);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!FacebookSdk.isInitialized()) {
            FacebookSdk.sdkInitialize((Context)this.getApplicationContext());
        }
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        log.debug("content changed");
    }

    @Override
    protected void onResume() {
        super.onResume();
        log.debug("resume");
        if (!this.shownDialog) {
            this.showShareDialog();
        }
    }

    private void showShareDialog() {
        this.shownDialog = true;
        log.debug("showing share dialog");
        CallbackManager callbackManager = CallbackManager.Factory.create();
        Uri uri = (Uri)this.getIntent().getParcelableExtra(EXTRA_URI);
        ShareDialog shareDialog = new ShareDialog((Activity)this);
        ShareLinkContent content = ((ShareLinkContent.Builder)new ShareLinkContent.Builder().setContentUrl(uri)).build();
        shareDialog.registerCallback(callbackManager, (FacebookCallback)new FacebookCallback<Sharer.Result>(){

            public void onSuccess(Sharer.Result result) {
                log.debug("success");
            }

            public void onCancel() {
                log.debug("cancel");
            }

            public void onError(FacebookException e) {
                log.error("error", (Throwable)e);
            }
        });
        shareDialog.show((Object)content);
    }
}

