/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.drawable;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.SystemClock;

public class CyclicTransitionDrawable
extends LayerDrawable
implements Drawable.Callback {
    protected Drawable[] drawables;
    protected int currentDrawableIndex;
    protected int alpha = 0;
    protected int fromAlpha;
    protected int toAlpha;
    protected long duration;
    protected long startTimeMillis;
    protected long pauseDuration;
    protected TransitionState transitionStatus;

    public CyclicTransitionDrawable(Drawable[] drawables) {
        super(drawables);
        this.drawables = drawables;
    }

    public void startTransition(int durationMillis, int pauseTimeMillis) {
        this.fromAlpha = 0;
        this.toAlpha = 255;
        this.duration = durationMillis;
        this.pauseDuration = pauseTimeMillis;
        this.startTimeMillis = SystemClock.uptimeMillis();
        this.transitionStatus = TransitionState.PAUSED;
        this.currentDrawableIndex = 0;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean done = true;
        switch (this.transitionStatus) {
            case STARTING: {
                done = false;
                this.transitionStatus = TransitionState.RUNNING;
                break;
            }
            case PAUSED: {
                if (SystemClock.uptimeMillis() - this.startTimeMillis < this.pauseDuration) break;
                done = false;
                this.startTimeMillis = SystemClock.uptimeMillis();
                this.transitionStatus = TransitionState.RUNNING;
            }
        }
        if (this.startTimeMillis >= 0L) {
            float normalized = (float)(SystemClock.uptimeMillis() - this.startTimeMillis) / (float)this.duration;
            done = normalized >= 1.0f;
            normalized = Math.min(normalized, 1.0f);
            this.alpha = (int)((float)this.fromAlpha + (float)(this.toAlpha - this.fromAlpha) * normalized);
        }
        if (this.transitionStatus == TransitionState.RUNNING) {
            int nextDrawableIndex = 0;
            if (this.currentDrawableIndex + 1 < this.drawables.length) {
                nextDrawableIndex = this.currentDrawableIndex + 1;
            }
            Drawable currentDrawable = this.getDrawable(this.currentDrawableIndex);
            Drawable nextDrawable = this.getDrawable(nextDrawableIndex);
            currentDrawable.setAlpha(255 - this.alpha);
            currentDrawable.draw(canvas);
            currentDrawable.setAlpha(255);
            if (this.alpha > 0) {
                nextDrawable.setAlpha(this.alpha);
                nextDrawable.draw(canvas);
                nextDrawable.setAlpha(255);
            }
            if (done) {
                this.currentDrawableIndex = nextDrawableIndex;
                this.startTimeMillis = SystemClock.uptimeMillis();
                this.transitionStatus = TransitionState.PAUSED;
            }
        } else {
            this.getDrawable(this.currentDrawableIndex).draw(canvas);
        }
        this.invalidateSelf();
    }

    protected static enum TransitionState {
        STARTING,
        PAUSED,
        RUNNING;

    }
}

