/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import butterknife.BindView;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.camera.ScannerFailedActivity$$Lambda$1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerFailedActivity
extends BaseActivity {
    private static final Logger log = LoggerFactory.getLogger(ScannerFailedActivity.class);
    public static final String EXTRA_IMAGE_URI = "EXTRA_IMAGE_URI";
    @BindView(value=2131689667)
    ImageView mImageView;
    @BindView(value=2131689669)
    ImageView mFaceView;
    Uri mImageUri;
    boolean mAnimatedFaceZoom;
    private static final int[] FACE_ANIMATIONS = new int[]{R.drawable.scanner_failed_face_shake_left_anim, R.drawable.scanner_failed_face_shake_right_anim, R.drawable.scanner_failed_face_blink_anim};
    private Runnable mFaceAnimationRunnable = ScannerFailedActivity$$Lambda$1.lambdaFactory$(this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getActivityComponent().inject(this);
        this.mImageUri = (Uri)this.getIntent().getParcelableExtra(EXTRA_IMAGE_URI);
        log.debug("image uri: {}", (Object)this.mImageUri);
        this.setContentView(R.layout.scan_failed_activity);
        this.hideActionBar();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.mFaceView.removeCallbacks(this.mFaceAnimationRunnable);
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        this.mImageView.setImageURI(this.mImageUri);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (!this.mAnimatedFaceZoom) {
            AnimationDrawable drawable2 = (AnimationDrawable)this.mFaceView.getDrawable();
            drawable2.start();
            this.mAnimatedFaceZoom = true;
            this.animateFace();
        }
    }

    public void onCloseButtonClick(View vw) {
        this.finish();
    }

    private void animateFace() {
        this.mFaceView.postDelayed(this.mFaceAnimationRunnable, this.randomFaceDelay());
    }

    private long randomFaceDelay() {
        return (long)(Math.random() * 4000.0 + 2000.0);
    }

    /* synthetic */ void lambda$new$0() {
        int action = (int)(Math.random() * 3.0);
        AnimationDrawable drawable2 = (AnimationDrawable)this.getResources().getDrawable(FACE_ANIMATIONS[action]);
        if (drawable2 != null) {
            this.mFaceView.setImageDrawable((Drawable)drawable2);
            drawable2.start();
        }
        this.animateFace();
    }
}

