/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.opengl.BitmapTexture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScannerBar {
    private static final Logger log = LoggerFactory.getLogger(ScannerBar.class);
    private static final int ANIMATION_DURATION_FRAMES = 150;
    private static final float FADE_IN_OFFSET = 0.5f;
    private static final float BAR_HEIGHT = 0.5f;
    private static final float BAR_TRAVEL = 1.5f;
    @NonNull
    private final BitmapTexture.BitmapTextureHelper mBitmapTextureHelper;
    @NonNull
    private final BitmapTexture mBar = new BitmapTexture();
    private int mFrame;
    private boolean mMovingDown;

    ScannerBar(@NonNull Context context, float width) {
        this.mBitmapTextureHelper = new BitmapTexture.BitmapTextureHelper(context, width, 0.5f, 0.0f, R.drawable.bar_texture, false);
    }

    private float getScannerProgress() {
        return (float)this.mFrame / 150.0f;
    }

    private void bumpFrame() {
        ++this.mFrame;
        if (this.mFrame >= 150) {
            this.mMovingDown = !this.mMovingDown;
            this.mBitmapTextureHelper.reloadTextureBuffer(false, this.mMovingDown);
            this.mFrame = 0;
        }
    }

    private float getDirectionFactor() {
        return this.mMovingDown ? -1.0f : 1.0f;
    }

    void drawScanner(@NonNull float[] mvpMatrix) {
        float newTranslationY = this.getDirectionFactor() * (1.0f - 2.0f * this.getScannerProgress()) * -1.5f;
        this.mBar.setTranslationY(newTranslationY);
        float absolutePosition = Math.abs(newTranslationY);
        if (absolutePosition < 0.5f) {
            this.mBar.setAlpha(1.0f);
        } else {
            float offsetSpan = 1.0f;
            this.mBar.setAlpha(1.0f - (absolutePosition - 0.5f) / offsetSpan);
        }
        this.mBitmapTextureHelper.preDraw();
        this.mBitmapTextureHelper.render(this.mBar, mvpMatrix);
        this.mBitmapTextureHelper.postDraw();
        this.bumpFrame();
    }

    public boolean isMovingDown() {
        return this.mMovingDown;
    }
}

