/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.os.Handler;
import android.os.Looper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nullable;
import lombok.NonNull;
import me.dm7.barcodescanner.zbar.BarcodeFormat;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;
import org.iqnect.iqkit.ui.camera.ScanResult;
import org.iqnect.iqkit.ui.camera.Scanner$$Lambda$1;
import org.iqnect.iqkit.ui.camera.ScannerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Scanner {
    private static final Logger log = LoggerFactory.getLogger(Scanner.class);
    private static final List<BarcodeFormat> BARCODE_FORMATS;
    private static final int SCAN_RESULT_NO_SYMBOLS = 0;
    private static final int SCAN_RESULT_ERROR = -1;
    private static final String IMAGE_FORMAT = "Y800";
    @NonNull
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    @NonNull
    private final BlockingQueue<Image> mQueue = new ArrayBlockingQueue<Image>(5);
    @NonNull
    private OnScanListener mOnScanListener;
    @Nullable
    private Thread mThread;

    Scanner() {
    }

    void setEnabled(boolean enabled) {
        boolean alreadyEnabled;
        boolean bl = alreadyEnabled = this.mThread != null;
        if (alreadyEnabled != enabled) {
            if (enabled) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    public void setScanListener(OnScanListener onScanListener) {
        this.mOnScanListener = onScanListener;
    }

    boolean isEnabled() {
        return this.mThread != null;
    }

    void scan(@NonNull byte[] data, int width, int height) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.mQueue.offer(Scanner.newImage(data, width, height));
    }

    private void start() {
        this.mThread = new Thread(){

            @Override
            public void run() {
                Scanner.this.scan();
            }
        };
        this.mThread.start();
    }

    private void stop() {
        if (this.mThread != null) {
            this.mThread.interrupt();
            this.mThread = null;
        }
    }

    private void scan() {
        try {
            Image image;
            while ((image = this.mQueue.take()) != null) {
                try {
                    this.dispatchResults(Scanner.scanImage(image));
                }
                catch (ScannerException e) {
                    log.error("Scan error", (Throwable)e);
                }
            }
        }
        catch (InterruptedException image) {
        }
        catch (Throwable e) {
            log.error("Error in scan loop", e);
        }
    }

    private void dispatchResults(@NonNull List<ScanResult> results) {
        if (results == null) {
            throw new NullPointerException("results");
        }
        this.mHandler.post(Scanner$$Lambda$1.lambdaFactory$(this, results));
    }

    @NonNull
    private static List<ScanResult> scanImage(@NonNull Image image) throws ScannerException {
        if (image == null) {
            throw new NullPointerException("image");
        }
        ImageScanner scanner = Scanner.newImageScanner();
        int result = scanner.scanImage(image);
        switch (result) {
            case -1: {
                log.debug("Scan error");
                throw new ScannerException("Error scanning preview frame");
            }
            case 0: {
                return Collections.emptyList();
            }
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (Symbol symbol : scanner.getResults()) {
            b.add((Object)new ScanResult(symbol.getData(), BarcodeFormat.getFormatById((int)symbol.getType())));
        }
        return b.build();
    }

    @NonNull
    private static Image newImage(@NonNull byte[] data, int width, int height) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        Image image = new Image();
        image.setData(data);
        image.setSize(width, height);
        image.setFormat(IMAGE_FORMAT);
        return image;
    }

    @NonNull
    private static ImageScanner newImageScanner() {
        ImageScanner scanner = new ImageScanner();
        scanner.setConfig(0, 256, 3);
        scanner.setConfig(0, 257, 3);
        scanner.setConfig(0, 0, 0);
        for (BarcodeFormat barcodeFormat : BARCODE_FORMATS) {
            scanner.setConfig(barcodeFormat.getId(), 0, 1);
        }
        return scanner;
    }

    /* synthetic */ void lambda$dispatchResults$0(@NonNull List results) {
        if (this.mOnScanListener != null) {
            this.mOnScanListener.onScan(results);
        }
    }

    static {
        System.loadLibrary("iconv");
        BARCODE_FORMATS = BarcodeFormat.ALL_FORMATS;
    }

    static interface OnScanListener {
        public void onScan(@NonNull List<ScanResult> var1);
    }
}

