/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import javax.annotation.Nullable;
import lombok.NonNull;
import me.dm7.barcodescanner.zbar.BarcodeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScanResult
implements Parcelable {
    private static final Logger log = LoggerFactory.getLogger(ScanResult.class);
    private static final String IQNECT_SCHEME = "iqnect://";
    @NonNull
    private final String mCode;
    @Nullable
    private final Uri mUri;
    public static final Parcelable.Creator<ScanResult> CREATOR = new Parcelable.Creator<ScanResult>(){

        public ScanResult createFromParcel(Parcel source) {
            return new ScanResult(source);
        }

        public ScanResult[] newArray(int size) {
            return new ScanResult[size];
        }
    };

    ScanResult(@NonNull String code, @NonNull BarcodeFormat format) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        log.debug("scan result code: {}, format: {}", (Object)code, (Object)format);
        this.mCode = code;
        this.mUri = format.equals(BarcodeFormat.QRCODE) && Patterns.WEB_URL.matcher(code).matches() || code.startsWith(IQNECT_SCHEME) ? Uri.parse((String)code) : null;
    }

    @Nullable
    public Uri asUri() {
        return this.mUri;
    }

    @NonNull
    public String asString() {
        return this.mCode;
    }

    public String toString() {
        return this.mCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCode);
        dest.writeParcelable((Parcelable)this.mUri, 0);
    }

    private ScanResult(Parcel in) {
        this.mCode = in.readString();
        this.mUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
    }
}

