/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.BindView;
import butterknife.OnClick;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.api.AppUpdate;
import org.iqnect.iqkit.api.NotFoundResponseException;
import org.iqnect.iqkit.model.SearchResult;
import org.iqnect.iqkit.search.SearchService;
import org.iqnect.iqkit.ui.Errors;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.BaseActivity;
import org.iqnect.iqkit.ui.app.SearchResultActivity;
import org.iqnect.iqkit.ui.camera.CameraOverlayView;
import org.iqnect.iqkit.ui.camera.CameraView;
import org.iqnect.iqkit.ui.camera.DeviceOrientationListener;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$1;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$11;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$2;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$3;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$4;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$7;
import org.iqnect.iqkit.ui.camera.IqKitScannerActivity$$Lambda$8;
import org.iqnect.iqkit.ui.camera.ScanResult;
import org.iqnect.iqkit.ui.util.ConnectivityUtils;
import org.iqnect.iqkit.ui.util.DeviceUtils;
import org.iqnect.iqkit.ui.util.PreferenceUtils;
import org.iqnect.iqkit.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IqKitScannerActivity
extends BaseActivity {
    private static final Logger log = LoggerFactory.getLogger(IqKitScannerActivity.class);
    private static final int PREVIEW_SEARCH_INTERVAL_MILLIS = 750;
    private static final float ACCELEROMETER_THRESHOLD = 1.75f;
    private static final int ACCELEROMETER_INTERVAL_MICROS = 100000;
    private static final float GYRO_THRESHOLD = 0.4f;
    private static final long GYRO_WINDOW_NANOS = 500000000L;
    private static final int GYRO_INTERVAL_MICROS = 10000;
    private static final String COMPONENT_NAME = "org.iqnect.iqkit.ui.ScannerActivity";
    public static final int STATUS_TEXT_CLEAR_DELAY_MILLIS = 2000;
    @NonNull
    private final Handler mHandler = new Handler();
    @NonNull
    protected final ThreadPoolExecutor mSearchExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    @BindView(value=2131689604)
    public CameraView mCameraView;
    @BindView(value=2131689605)
    public CameraOverlayView mCameraOverlay;
    @BindView(value=2131689613)
    public ImageView mFlashButton;
    @BindView(value=2131689608)
    public View mHintsView;
    @BindView(value=2131689609)
    public TextView mStabilityWarningView;
    @BindView(value=2131689607)
    public View mViewFinder;
    @BindView(value=2131689620)
    public ImageView mPoweredByIqnectView;
    @Inject
    Bus mBus;
    @Inject
    SearchService mSearchService;
    @Inject
    Errors mErrors;
    @Nullable
    private SensorManager mSensorManager;
    @NonNull
    private final SensorEventListener mSensorEventListener = new SensorListener(this);
    @NonNull
    private final DeviceOrientationListener mDeviceOrientationListener = new DeviceOrientationListener();
    @NonNull
    private final Runnable mClearStatusViewRunnable = new Runnable(){

        @Override
        public void run() {
            IqKitScannerActivity.this.mStabilityWarningView.setText((CharSequence)"");
            IqKitScannerActivity.this.mDeviceSteady = true;
        }
    };
    private volatile long mLastPreviewSearchTime = System.currentTimeMillis();
    private long mAccelerometerTimestamp;
    @NonNull
    private final Deque<float[]> mGyroscopeEvents = new ArrayDeque<float[]>();
    private boolean mGyroscopeQueueReady;
    private long mGyroscopeStartTime;
    private int mCurrentZoom;
    private int mMaxZoom;
    @Nullable
    private AlertDialog mErrorDialog;
    @Nullable
    private FrameReceiver mNextFrameReceiver;
    private boolean mZoomSupported;
    private boolean mUserInteracting;
    private boolean mUseGyroscope;
    private boolean mFlashOn;
    private boolean mErrorDialogShown;
    private boolean mDeviceSteady;
    private int mFrame;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getActivityComponent().inject(this);
        this.setContentView(R.layout.scanner_activity);
        this.hideActionBar();
        Window window = this.getWindow();
        window.addFlags(640);
        this.mCameraView.setOnScanResultListener(IqKitScannerActivity$$Lambda$1.lambdaFactory$(this));
        this.mCameraView.setOverlayView(this.mCameraOverlay);
        this.mSensorManager = (SensorManager)this.getApplicationContext().getSystemService("sensor");
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.setStatusViewText(false);
        this.resumeScanning();
        this.updateZoomControl();
        if (this.mSensorManager != null) {
            Sensor gyro = this.mSensorManager.getDefaultSensor(4);
            boolean bl = this.mUseGyroscope = gyro != null;
            if (this.mUseGyroscope) {
                log.debug("Gyroscope found, registering listener");
                this.mSensorManager.registerListener(this.mSensorEventListener, gyro, 10000);
            } else {
                log.debug("Device does not have a gyroscope");
            }
            Sensor accelerometer = this.mSensorManager.getDefaultSensor(1);
            if (accelerometer != null) {
                log.debug("Accelerometer found, registering listener");
                this.mSensorManager.registerListener(this.mSensorEventListener, accelerometer, 100000);
            } else {
                log.debug("Device does not have an accelerometer");
            }
            Sensor magnetometer = this.mSensorManager.getDefaultSensor(2);
            this.mSensorManager.registerListener(this.mSensorEventListener, magnetometer, 10000);
            this.mAccelerometerTimestamp = 0L;
            this.mGyroscopeStartTime = 0L;
        }
        this.mErrorDialogShown = false;
        boolean shownHints = PreferenceUtils.readBooleanPreference(this.getApplicationContext(), "shown_hints");
        if (!shownHints) {
            PreferenceUtils.writeBooleanPreference(this.getApplicationContext(), "shown_hints", true);
            this.setHintsViewVisibility(0);
        }
    }

    protected void resumeScanning() {
        this.mCameraView.onResume(this.getWindowManager().getDefaultDisplay().getRotation());
        this.mCameraView.setPreviewCallback(IqKitScannerActivity$$Lambda$2.lambdaFactory$(this));
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.pauseScanning();
        this.resetFlashIcon();
        if (this.mSensorManager != null) {
            try {
                this.mSensorManager.unregisterListener(this.mSensorEventListener);
            }
            catch (IllegalArgumentException e) {
                log.error("error unregistering sensor event listener", (Throwable)e);
            }
        }
        this.setStatusViewText(false);
        this.mViewFinder.setOnTouchListener(null);
        if (!DeviceUtils.isScreenOn((Context)this)) {
            this.finish();
        }
    }

    protected void pauseScanning() {
        this.mCameraView.onPause();
        this.mCameraView.setPreviewCallback(null);
    }

    protected void hideCameraOverlay() {
        if (this.mCameraOverlay.getVisibility() != 4) {
            this.mCameraOverlay.setVisibility(4);
        }
    }

    protected void showCameraOverlay() {
        if (this.shouldShowScannerBar() && this.mCameraOverlay.getVisibility() != 0) {
            this.mCameraOverlay.setVisibility(0);
        }
    }

    public int getOrientation() {
        return this.mDeviceOrientationListener.getOrientation();
    }

    public void onSensorChanged(SensorEvent event) {
        boolean sensorAccurate;
        int sensorType = event.sensor.getType();
        boolean bl = sensorAccurate = event.accuracy >= 1;
        if (sensorType == 1 || sensorType == 2) {
            this.mDeviceOrientationListener.onSensorChanged(event);
        }
        if (sensorType == 4) {
            this.mUseGyroscope = sensorAccurate;
            if (!this.mUseGyroscope) {
                return;
            }
            this.mGyroscopeEvents.add(new float[]{event.values[0], event.values[1], event.values[2]});
            long currentTime = event.timestamp;
            if (this.mGyroscopeStartTime == 0L) {
                this.mGyroscopeStartTime = currentTime;
            } else if (this.mGyroscopeQueueReady) {
                this.mGyroscopeEvents.removeFirst();
                boolean showWarning = false;
                float[] axisSums = new float[3];
                for (float[] eventValues : this.mGyroscopeEvents) {
                    for (int i = 0; i < axisSums.length; ++i) {
                        int n = i;
                        axisSums[n] = axisSums[n] + Math.abs(eventValues[i]);
                    }
                }
                for (Object sum : (Object)axisSums) {
                    if (!(sum / (float)this.mGyroscopeEvents.size() > 0.4f)) continue;
                    showWarning = true;
                    break;
                }
                this.setStatusViewText(showWarning);
            } else if (currentTime - this.mGyroscopeStartTime > 500000000L) {
                this.mGyroscopeQueueReady = true;
            }
        }
        if (!this.mUseGyroscope && sensorType == 1) {
            if (!sensorAccurate) {
                return;
            }
            if (this.mAccelerometerTimestamp != 0L) {
                float x = event.values[0] / 9.80665f;
                float y = event.values[1] / 9.80665f;
                float z = event.values[2] / 9.80665f;
                float magnitude = x * x + y * y + z * z;
                this.setStatusViewText(magnitude > 1.75f);
            }
            this.mAccelerometerTimestamp = event.timestamp;
        }
    }

    public boolean isMenuDrawerOpen() {
        return false;
    }

    @Subscribe
    private void onCameraAttachError(@NonNull CameraView.AttachError attachError) {
        if (attachError == null) {
            throw new NullPointerException("attachError");
        }
        String msg = attachError.getThrowable() == null ? this.getString(R.string.camera_attach_error_no_cameras) : this.getString(R.string.camera_attach_error_unexpected) + "\n" + attachError.getThrowable().getMessage();
        new AlertDialog.Builder((Context)this, R.style.AlertDialogTheme).setMessage((CharSequence)msg).setPositiveButton(17039370, IqKitScannerActivity$$Lambda$3.lambdaFactory$()).show();
    }

    protected boolean shouldDispatchBitmap() {
        return System.currentTimeMillis() - this.mLastPreviewSearchTime >= 750L && this.isActivityStable() && this.mDeviceSteady && this.mSearchExecutor.getActiveCount() == 0;
    }

    protected boolean isActivityStable() {
        return this.isActivityResumed() && !this.mUserInteracting && this.mHintsView.getVisibility() != 0 && !this.isMenuDrawerOpen();
    }

    protected boolean shouldShowScannerBar() {
        return true;
    }

    protected boolean onFling(@NonNull MotionEvent startEvent, @NonNull MotionEvent endEvent) {
        if (startEvent == null) {
            throw new NullPointerException("startEvent");
        }
        if (endEvent == null) {
            throw new NullPointerException("endEvent");
        }
        return false;
    }

    public void onPreviewFrame(@NonNull byte[] data, @NonNull Camera camera) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (camera == null) {
            throw new NullPointerException("camera");
        }
        if (this.mNextFrameReceiver != null) {
            this.mNextFrameReceiver.onPreviewFrame(data, camera);
            this.mNextFrameReceiver = null;
        } else if (this.shouldDispatchBitmap()) {
            this.startImageSearch(data, camera, Frame.values()[this.mFrame]);
            this.mFrame = (this.mFrame + 1) % Frame.values().length;
        }
    }

    private void startImageSearch(@NonNull byte[] data, @NonNull Camera camera, @NonNull Frame frame) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (camera == null) {
            throw new NullPointerException("camera");
        }
        if (frame == null) {
            throw new NullPointerException("frame");
        }
        log.debug("processing preview frame");
        int cameraOrientation = this.mCameraView.getCameraOrientation();
        Runnable searchRunnable = IqKitScannerActivity$$Lambda$4.lambdaFactory$(this, data, camera, frame, cameraOrientation);
        this.executeSearchIfPossible(searchRunnable);
    }

    protected boolean executeSearchIfPossible(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        if (this.mSearchExecutor.getActiveCount() > 0) {
            log.debug("search already running");
            return false;
        }
        this.mSearchExecutor.submit(runnable);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Nullable
    protected Bitmap processFrame(@NonNull byte[] data, @NonNull Camera camera) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (camera == null) {
            throw new NullPointerException("camera");
        }
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size size = parameters.getPreviewSize();
        Bitmap bitmap = null;
        ByteArrayOutputStream out = null;
        try {
            YuvImage yuv = new YuvImage(data, parameters.getPreviewFormat(), size.width, size.height, null);
            out = new ByteArrayOutputStream();
            yuv.compressToJpeg(new Rect(0, 0, size.width, size.height), 100, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            IoUtils.closeQuietly((Closeable)out);
        }
        catch (Exception e) {
            log.error("error while decoding image", (Throwable)e);
            Bitmap bitmap2 = null;
            return bitmap2;
        }
        finally {
            IoUtils.closeQuietly(out);
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width <= 0 || height <= 0) {
            log.error("invalid bitmap");
            return null;
        }
        return bitmap;
    }

    protected int getDeviceOrientation() {
        return this.mDeviceOrientationListener.getOrientation();
    }

    protected void adjustMatrixForDeviceOrientation(Matrix matrix) {
        switch (this.getDeviceOrientation()) {
            case 6: {
                break;
            }
            case 8: {
                matrix.postRotate(180.0f);
                break;
            }
            case 1: {
                matrix.postRotate(270.0f);
                break;
            }
            case 3: {
                matrix.postRotate(90.0f);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @WorkerThread
    private void dispatchBitmap(@NonNull Bitmap source, int x, int y, int width, int height, @NonNull Matrix m) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void start(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity");
        }
        activity.startActivity(IqKitScannerActivity.startIntent((Context)activity));
    }

    public static void start(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        fragment.startActivity(IqKitScannerActivity.startIntent((Context)fragment.getActivity()));
    }

    private static Intent startIntent(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(context.getApplicationContext().getPackageName(), COMPONENT_NAME));
        intent.setFlags(0x20400000);
        return intent;
    }

    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        log.debug("dispatchKeyEvent");
        int action = event.getAction();
        int keyCode = event.getKeyCode();
        if (this.mZoomSupported) {
            switch (keyCode) {
                case 24: 
                case 25: {
                    boolean bl = this.mUserInteracting = action == 0;
                    if (this.mUserInteracting) {
                        this.updateZoom(this.mCurrentZoom + this.getZoomIncrement(keyCode == 24));
                    }
                    return true;
                }
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private int getZoomIncrement(boolean zoomIn) {
        return Math.max(1, this.mMaxZoom / 10) * (zoomIn ? 1 : -1);
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        if (ev == null) {
            throw new NullPointerException("ev");
        }
        switch (ev.getAction()) {
            case 0: {
                log.debug("user touch started");
                this.mUserInteracting = true;
                break;
            }
            case 1: 
            case 3: {
                log.debug("user touch finished");
                this.mUserInteracting = false;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void returnError(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable");
        }
        try {
            if (!this.isActivityResumed()) {
                log.debug("error returned after activity paused", throwable);
            } else if (throwable instanceof NotFoundResponseException) {
                log.debug("not found response");
            } else {
                log.error("scan error", throwable);
                this.handleError(throwable);
            }
        }
        catch (Exception e) {
            log.error("error returning error", (Throwable)e);
        }
    }

    protected void handleError(@Nullable Throwable throwable) {
        this.handleError(throwable, false);
    }

    protected void handleError(@Nullable Throwable throwable, boolean forceDialog) {
        AppUpdate appUpdate = AppUpdate.fromThrowable((Throwable)throwable);
        if (appUpdate != null && appUpdate.isRequired()) {
            this.mBus.post((Object)new AppUpdate.Event(appUpdate));
        } else {
            this.runOnUiThread(IqKitScannerActivity$$Lambda$7.lambdaFactory$(this, throwable, forceDialog));
        }
    }

    private void returnSearchResult(@Nullable SearchResult searchResult) {
        if (this.isActivityResumed() && searchResult != null) {
            log.debug("returning search result: {}", (Object)searchResult);
            this.resetFlashIcon();
            Intent searchResultIntent = SearchResultActivity.getSearchResultIntent((Context)this, searchResult);
            this.startActivity(searchResultIntent);
        }
    }

    protected void resetFlashIcon() {
        this.mFlashButton.setImageResource(R.drawable.flash_off);
        this.mFlashOn = false;
    }

    @OnClick(value={2131689614, 2131689616, 2131689608})
    public void onHintsButtonClick() {
        int desiredVisibility = this.mHintsView.getVisibility() == 0 ? 4 : 0;
        this.setHintsViewVisibility(desiredVisibility);
    }

    private void setHintsViewVisibility(int visibility) {
        this.mHintsView.setVisibility(visibility);
        int statusVisibility = visibility == 0 ? 4 : 0;
        this.mStabilityWarningView.setVisibility(statusVisibility);
        this.mViewFinder.setVisibility(statusVisibility);
        this.mCameraOverlay.setVisibility(this.shouldShowScannerBar() ? statusVisibility : 4);
        if (visibility == 0) {
            this.mCameraView.pauseDispatchQrCode();
        } else {
            this.mCameraView.resumeDispatchQrCode();
        }
    }

    private void setStatusViewText(boolean warning) {
        boolean bl = this.mDeviceSteady = !warning;
        if (warning) {
            this.mStabilityWarningView.setText((CharSequence)this.getString(R.string.camera_steady_warning));
            this.mHandler.removeCallbacks(this.mClearStatusViewRunnable);
            this.mHandler.postDelayed(this.mClearStatusViewRunnable, 2000L);
        }
    }

    private void updateZoomControl() {
        this.mZoomSupported = this.mCameraView.supportsZoom();
        if (this.mZoomSupported) {
            this.mCurrentZoom = this.mCameraView.getZoom();
            this.mMaxZoom = this.mCameraView.getMaxZoom();
            if (this.mCurrentZoom >= 0 && this.mMaxZoom >= 0) {
                GestureDetector tapDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)new TapToFocusListener());
                ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector((Context)this, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener(this));
                this.mViewFinder.setOnTouchListener(IqKitScannerActivity$$Lambda$8.lambdaFactory$(tapDetector, scaleGestureDetector));
            } else {
                log.debug("error in zoom levels, current: {}, max: {}", (Object)this.mCurrentZoom, (Object)this.mMaxZoom);
                this.mCurrentZoom = -1;
                this.mMaxZoom = -1;
                this.mZoomSupported = false;
            }
        }
    }

    private void updateZoom(int level) {
        if (!this.mZoomSupported) {
            log.debug("somehow update zoom was called when zoom not supported. level: {}", (Object)level);
            return;
        }
        if (level != this.mCurrentZoom && level >= 0 && level <= this.mMaxZoom) {
            try {
                log.debug("setting zoom to {}", (Object)level);
                this.mCurrentZoom = level;
                this.mCameraView.setZoom(this.mCurrentZoom);
            }
            catch (Exception e) {
                log.error("error zooming camera", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void onScanResult(@NonNull List<ScanResult> scanResults) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @OnClick(value={2131689613})
    public void onFlashButtonClick() {
        this.cycleFlashMode();
    }

    protected void cycleFlashMode() {
        String flash = this.mCameraView.cycleFlashMode();
        log.debug("new flash mode={}", (Object)flash);
        if (flash == null) {
            return;
        }
        if (flash.equals("on") || flash.equals("auto") || flash.equals("torch")) {
            this.mFlashButton.setImageResource(R.drawable.flash_on);
            this.mFlashOn = true;
        } else {
            this.mFlashButton.setImageResource(R.drawable.flash_off);
            this.mFlashOn = false;
        }
    }

    protected void turnFlashOff() {
        if (this.mFlashOn) {
            this.cycleFlashMode();
        }
    }

    public int getCurrentZoom() {
        return this.mCurrentZoom;
    }

    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    @Nullable
    public FrameReceiver getNextFrameReceiver() {
        return this.mNextFrameReceiver;
    }

    protected void setNextFrameReceiver(@Nullable FrameReceiver mNextFrameReceiver) {
        this.mNextFrameReceiver = mNextFrameReceiver;
    }

    static /* synthetic */ boolean lambda$updateZoomControl$4(GestureDetector tapDetector, ScaleGestureDetector scaleGestureDetector, View v, MotionEvent event) {
        boolean consumed = tapDetector.onTouchEvent(event);
        if (consumed) {
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)event);
            cancelEvent.setAction(3);
            scaleGestureDetector.onTouchEvent(cancelEvent);
            cancelEvent.recycle();
            return true;
        }
        MotionEvent scaleEvent = MotionEvent.obtain((MotionEvent)event);
        scaleEvent.setLocation(event.getRawX(), event.getRawY());
        boolean scaleConsumed = scaleGestureDetector.onTouchEvent(scaleEvent);
        scaleEvent.recycle();
        return scaleConsumed;
    }

    /* synthetic */ void lambda$handleError$3(@Nullable Throwable throwable, boolean forceDialog) {
        if (this.mErrorDialog == null) {
            String errorMessage;
            if (!ConnectivityUtils.hasConnection((Context)this)) {
                errorMessage = this.getString(R.string.no_internet_msg);
            } else {
                String defaultMessage = this.getString(R.string.general_error);
                errorMessage = throwable != null ? this.mErrors.getMessage(throwable, defaultMessage) : defaultMessage;
            }
            this.mErrorDialog = new AlertDialog.Builder((Context)this, R.style.AlertDialogTheme).setMessage((CharSequence)errorMessage).setPositiveButton(17039370, IqKitScannerActivity$$Lambda$11.lambdaFactory$(this)).create();
        }
        if (!(this.mErrorDialog.isShowing() || this.mErrorDialogShown && !forceDialog)) {
            this.mErrorDialog.show();
        }
    }

    /* synthetic */ void lambda$null$2(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.mErrorDialogShown = true;
    }

    /* synthetic */ void lambda$startImageSearch$1(@NonNull byte[] data, @NonNull Camera camera, @NonNull Frame frame, int cameraOrientation) {
        this.mLastPreviewSearchTime = System.currentTimeMillis();
        Bitmap bitmap = this.processFrame(data, camera);
        if (bitmap == null) {
            log.error("invalid bitmap, aborting");
            return;
        }
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        float preCropHeight = 1.0f / (1.0f - frame.heightCrop) * 640.0f;
        float scale = preCropHeight / (float)width;
        int startX = (int)((float)width * frame.heightCrop / 2.0f);
        int bitmapX = (int)((float)width * (1.0f - frame.heightCrop));
        int startY = (int)((float)height * frame.widthCrop / 2.0f);
        int bitmapY = (int)((float)height * (1.0f - frame.widthCrop));
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        this.adjustMatrixForDeviceOrientation(matrix);
        matrix.postRotate((float)cameraOrientation);
        this.dispatchBitmap(bitmap, startX, startY, bitmapX, bitmapY, matrix);
        bitmap.recycle();
    }

    static /* synthetic */ void lambda$onCameraAttachError$0(DialogInterface dialog, int which) {
        dialog.dismiss();
    }

    static /* synthetic */ void access$lambda$0(IqKitScannerActivity iqKitScannerActivity, List list) {
        iqKitScannerActivity.onScanResult(list);
    }

    static /* synthetic */ void access$lambda$1(IqKitScannerActivity iqKitScannerActivity, SearchResult searchResult) {
        iqKitScannerActivity.returnSearchResult(searchResult);
    }

    static /* synthetic */ void access$lambda$2(IqKitScannerActivity iqKitScannerActivity, Throwable throwable) {
        iqKitScannerActivity.returnError(throwable);
    }

    static /* synthetic */ void access$lambda$3(IqKitScannerActivity iqKitScannerActivity, SearchResult searchResult) {
        iqKitScannerActivity.returnSearchResult(searchResult);
    }

    static /* synthetic */ void access$lambda$4(IqKitScannerActivity iqKitScannerActivity, Throwable throwable) {
        iqKitScannerActivity.returnError(throwable);
    }

    private class TapToFocusListener
    extends GestureDetector.SimpleOnGestureListener {
        private TapToFocusListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            IqKitScannerActivity.this.mCameraView.onTapToFocus(e);
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return IqKitScannerActivity.this.onFling(e1, e2) || super.onFling(e1, e2, velocityX, velocityY);
        }
    }

    private static final class SensorListener
    implements SensorEventListener {
        @NonNull
        private final WeakReference<IqKitScannerActivity> mActivity;

        private SensorListener(@NonNull IqKitScannerActivity scannerActivity) {
            if (scannerActivity == null) {
                throw new NullPointerException("scannerActivity");
            }
            this.mActivity = new WeakReference<IqKitScannerActivity>(scannerActivity);
        }

        public void onSensorChanged(@NonNull SensorEvent event) {
            if (event == null) {
                throw new NullPointerException("event");
            }
            IqKitScannerActivity activity = (IqKitScannerActivity)((Object)this.mActivity.get());
            if (activity != null) {
                activity.onSensorChanged(event);
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    protected static interface FrameReceiver {
        public void onPreviewFrame(@NonNull byte[] var1, @NonNull Camera var2);
    }

    private static final class ScaleListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        @NonNull
        private final WeakReference<IqKitScannerActivity> mActivity;
        private float mScaleFactor = 1.0f;
        private int mBaseZoom = -1;
        private int mMaxZoom = -1;

        private ScaleListener(@NonNull IqKitScannerActivity scannerActivity) {
            if (scannerActivity == null) {
                throw new NullPointerException("scannerActivity");
            }
            this.mActivity = new WeakReference<IqKitScannerActivity>(scannerActivity);
        }

        private int getBaseZoom() {
            IqKitScannerActivity activity = (IqKitScannerActivity)((Object)this.mActivity.get());
            return activity != null ? activity.getCurrentZoom() : -1;
        }

        private int getMaxZoom() {
            IqKitScannerActivity activity = (IqKitScannerActivity)((Object)this.mActivity.get());
            return activity != null ? activity.getMaxZoom() : -1;
        }

        private int getZoomFactor(float scaleFactor) {
            if (scaleFactor >= 1.0f) {
                return (int)((scaleFactor - 1.0f) * (float)this.mMaxZoom);
            }
            return (int)((1.0f / scaleFactor - 1.0f) * (float)(-this.mMaxZoom));
        }

        public boolean onScale(@NonNull ScaleGestureDetector detector) {
            if (detector == null) {
                throw new NullPointerException("detector");
            }
            IqKitScannerActivity activity = (IqKitScannerActivity)((Object)this.mActivity.get());
            if (activity == null) {
                log.debug("activity is null, aborting");
                return false;
            }
            this.mScaleFactor *= detector.getScaleFactor();
            this.mScaleFactor = Math.max(0.1f, Math.min(this.mScaleFactor, 5.0f));
            int desiredZoom = this.mBaseZoom + this.getZoomFactor(this.mScaleFactor);
            activity.updateZoom(desiredZoom);
            log.debug("scale factor: {}, sent value: {}", (Object)Float.valueOf(this.mScaleFactor), (Object)desiredZoom);
            return true;
        }

        public boolean onScaleBegin(@NonNull ScaleGestureDetector detector) {
            if (detector == null) {
                throw new NullPointerException("detector");
            }
            this.mScaleFactor = 1.0f;
            this.mBaseZoom = this.getBaseZoom();
            this.mMaxZoom = this.getMaxZoom();
            log.debug("base zoom: {}, max zoom: {}", (Object)this.mBaseZoom, (Object)this.mMaxZoom);
            return this.mBaseZoom >= 0 && this.mMaxZoom >= 0;
        }

        public void onScaleEnd(@NonNull ScaleGestureDetector detector) {
            if (detector == null) {
                throw new NullPointerException("detector");
            }
            this.mScaleFactor = 1.0f;
            this.mBaseZoom = -1;
            this.mMaxZoom = -1;
        }
    }

    private static enum Frame {
        ONE(0.0f, 0.2f),
        TWO(0.3333f, 0.5f);

        final float widthCrop;
        final float heightCrop;

        private Frame(float widthCrop, float heightCrop) {
            this.widthCrop = widthCrop;
            this.heightCrop = heightCrop;
        }
    }
}

