/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class DeviceOrientationListener {
    public static final int ORIENTATION_PORTRAIT = 6;
    public static final int ORIENTATION_LANDSCAPE_REVERSE = 3;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT_REVERSE = 8;
    private int mSmoothness = 100;
    private float mAveragePitch = 0.0f;
    private float mAverageRoll = 0.0f;
    private int mOrientation = 6;
    private float[] mPitches;
    private float[] mRolls;
    SensorEventListener mSensorListener = new SensorEventListener(){
        float[] mGravity;
        float[] mGeomagnetic;

        public void onSensorChanged(SensorEvent event) {
            float[] I;
            float[] R3;
            boolean success;
            if (event.sensor.getType() == 1) {
                this.mGravity = event.values;
            }
            if (event.sensor.getType() == 2) {
                this.mGeomagnetic = event.values;
            }
            if (this.mGravity != null && this.mGeomagnetic != null && (success = SensorManager.getRotationMatrix((float[])(R3 = new float[9]), (float[])(I = new float[9]), (float[])this.mGravity, (float[])this.mGeomagnetic))) {
                float[] orientationData = new float[3];
                SensorManager.getOrientation((float[])R3, (float[])orientationData);
                DeviceOrientationListener.this.mAveragePitch = DeviceOrientationListener.this.addValue(orientationData[1], DeviceOrientationListener.this.mPitches);
                DeviceOrientationListener.this.mAverageRoll = DeviceOrientationListener.this.addValue(orientationData[2], DeviceOrientationListener.this.mRolls);
                DeviceOrientationListener.this.mOrientation = DeviceOrientationListener.this.calculateOrientation();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public DeviceOrientationListener() {
        this.mPitches = new float[this.mSmoothness];
        this.mRolls = new float[this.mSmoothness];
    }

    public void onSensorChanged(SensorEvent event) {
        this.mSensorListener.onSensorChanged(event);
    }

    private static String getOrientationName(int orientation) {
        switch (orientation) {
            case 6: {
                return "portrait";
            }
            case 1: {
                return "landscape";
            }
            case 3: {
                return "landscape reverse";
            }
            case 8: {
                return "portrait reverse";
            }
        }
        return "what?";
    }

    private float addValue(float value, float[] values) {
        value = Math.round(Math.toDegrees(value));
        float average = 0.0f;
        for (int i = 1; i < this.mSmoothness; ++i) {
            values[i - 1] = values[i];
            average += values[i];
        }
        values[this.mSmoothness - 1] = value;
        average = (average + value) / (float)this.mSmoothness;
        return average;
    }

    private int calculateOrientation() {
        if ((this.mOrientation == 6 || this.mOrientation == 8) && this.mAverageRoll > -30.0f && this.mAverageRoll < 30.0f) {
            if (this.mAveragePitch > 0.0f) {
                return 8;
            }
            return 6;
        }
        if (Math.abs(this.mAveragePitch) >= 30.0f) {
            if (this.mAveragePitch > 0.0f) {
                return 8;
            }
            return 6;
        }
        if (this.mAverageRoll > 0.0f) {
            return 3;
        }
        return 1;
    }

    public int getOrientation() {
        return this.mOrientation;
    }
}

