/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.camera;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.iqnect.iqkit.ui.camera.ScannerBar;
import org.iqnect.iqkit.ui.opengl.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CameraOverlayRenderer
extends Renderer {
    private static final Logger log = LoggerFactory.getLogger(CameraOverlayRenderer.class);
    @NonNull
    private final float[] mMVPMatrix = new float[16];
    @NonNull
    private final float[] mProjectionMatrix = new float[16];
    @NonNull
    private final float[] mViewMatrix = new float[16];
    @Nullable
    private ScannerBar mScannerBar;
    @NonNull
    private final Context mContext;

    CameraOverlayRenderer(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        super.onSurfaceCreated(gl, config);
        Process.setThreadPriority((int)-1);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glDisable((int)2929);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        float ratio = (float)width / (float)height;
        Matrix.frustumM((float[])this.mProjectionMatrix, (int)0, (float)(-ratio), (float)ratio, (float)-1.0f, (float)1.0f, (float)2.0f, (float)10.0f);
        this.mScannerBar = new ScannerBar(this.mContext, ratio * 2.0f);
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mScannerBar == null) {
            log.error("something bad has happened here...");
            return;
        }
        GLES20.glClear((int)16640);
        Matrix.setLookAtM((float[])this.mViewMatrix, (int)0, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mViewMatrix, (int)0);
        this.mScannerBar.drawScanner(this.mMVPMatrix);
    }
}

