/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.StringRes;
import android.view.ContextThemeWrapper;
import javax.inject.Inject;
import lombok.NonNull;
import org.iqnect.iqkit.ui.Errors;
import org.iqnect.iqkit.ui.R;

public class Alerts {
    @NonNull
    private final Activity mActivity;
    @NonNull
    private final Errors mErrors;

    @Inject
    public Alerts(@NonNull Activity activity, @NonNull Errors errors) {
        if (activity == null) {
            throw new NullPointerException("activity");
        }
        if (errors == null) {
            throw new NullPointerException("errors");
        }
        this.mActivity = activity;
        this.mErrors = errors;
    }

    @NonNull
    public AlertDialog.Builder buildDialog() {
        return new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.mActivity, R.style.iQNECT_Dialog_Alert));
    }

    @NonNull
    public Dialog showAlertDialog(@StringRes int messageId) {
        return this.buildDialog().setMessage(messageId).setPositiveButton(R.string.ok, null).show();
    }

    @NonNull
    public Dialog showErrorDialog(@NonNull Throwable e) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        return this.buildDialog().setTitle((CharSequence)this.mErrors.getTitle(e)).setMessage((CharSequence)this.mErrors.getMessage(e)).setPositiveButton(R.string.ok, null).show();
    }
}

