/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import com.getbase.floatingactionbutton.FloatingActionButton;
import org.iqnect.iqkit.ui.R;

public class AddFloatingActionButton
extends FloatingActionButton {
    int mPlusColor;

    public AddFloatingActionButton(Context context) {
        this(context, null);
    }

    public AddFloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AddFloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    void init(Context context, AttributeSet attributeSet) {
        TypedArray attr2 = context.obtainStyledAttributes(attributeSet, R.styleable.AddFloatingActionButton, 0, 0);
        this.mPlusColor = attr2.getColor(R.styleable.AddFloatingActionButton_fab_plusIconColor, this.getColor(17170443));
        attr2.recycle();
        super.init(context, attributeSet);
    }

    public int getPlusColor() {
        return this.mPlusColor;
    }

    public void setPlusColorResId(@ColorRes int plusColor) {
        this.setPlusColor(this.getColor(plusColor));
    }

    public void setPlusColor(int color2) {
        if (this.mPlusColor != color2) {
            this.mPlusColor = color2;
            this.updateBackground();
        }
    }

    @Override
    public void setIcon(@DrawableRes int icon) {
        throw new UnsupportedOperationException("Use FloatingActionButton if you want to use custom icon");
    }

    @Override
    Drawable getIconDrawable() {
        final float iconSize = this.getDimension(R.dimen.fab_icon_size);
        final float iconHalfSize = iconSize / 2.0f;
        float plusSize = this.getDimension(R.dimen.fab_plus_icon_size);
        final float plusHalfStroke = this.getDimension(R.dimen.fab_plus_icon_stroke) / 2.0f;
        final float plusOffset = (iconSize - plusSize) / 2.0f;
        Shape shape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                canvas.drawRect(plusOffset, iconHalfSize - plusHalfStroke, iconSize - plusOffset, iconHalfSize + plusHalfStroke, paint);
                canvas.drawRect(iconHalfSize - plusHalfStroke, plusOffset, iconHalfSize + plusHalfStroke, iconSize - plusOffset, paint);
            }
        };
        ShapeDrawable drawable2 = new ShapeDrawable(shape);
        Paint paint = drawable2.getPaint();
        paint.setColor(this.mPlusColor);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        return drawable2;
    }
}

