/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.QuantityFactory;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.AbstractUnit;
import tec.uom.se.unit.Units;

abstract class ProxyQuantityFactory<Q extends Quantity<Q>>
implements QuantityFactory<Q> {
    private static final ConcurrentHashMap<Class, ProxyQuantityFactory> INSTANCES = new ConcurrentHashMap();
    private static final Logger logger = Logger.getLogger(ProxyQuantityFactory.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;

    ProxyQuantityFactory() {
    }

    public static <Q extends Quantity<Q>> ProxyQuantityFactory<Q> getInstance(Class<Q> type) {
        ProxyQuantityFactory factory;
        logger.log(LOG_LEVEL, "Type: " + type + ": " + type.isInterface());
        if (!type.isInterface()) {
            if (type != null && type.getInterfaces() != null & type.getInterfaces().length > 0) {
                logger.log(LOG_LEVEL, "Type0: " + type.getInterfaces()[0]);
                Class<?> type2 = type.getInterfaces()[0];
                factory = INSTANCES.get(type2);
                if (factory != null) {
                    return factory;
                }
                if (!AbstractQuantity.class.isAssignableFrom(type2)) {
                    throw new ClassCastException();
                }
                factory = new Default(type2);
                INSTANCES.put(type2, factory);
            } else {
                factory = INSTANCES.get(type);
                if (factory != null) {
                    return factory;
                }
                if (!AbstractQuantity.class.isAssignableFrom(type)) {
                    throw new ClassCastException();
                }
                factory = new Default<Q>(type);
                INSTANCES.put(type, factory);
            }
        } else {
            factory = INSTANCES.get(type);
            if (factory != null) {
                return factory;
            }
            if (!Quantity.class.isAssignableFrom(type)) {
                throw new ClassCastException();
            }
            factory = new Default<Q>(type);
            INSTANCES.put(type, factory);
        }
        return factory;
    }

    protected static <Q extends Quantity<Q>> void setInstance(Class<Q> type, ProxyQuantityFactory<Q> factory) {
        if (!AbstractQuantity.class.isAssignableFrom(type)) {
            throw new ClassCastException();
        }
        INSTANCES.put(type, factory);
    }

    public abstract Unit<Q> getSystemUnit();

    private static final class GenericHandler<Q extends Quantity<Q>>
    implements InvocationHandler {
        final Unit<Q> unit;
        final Number value;

        GenericHandler(Number value, Unit<Q> unit) {
            this.unit = unit;
            this.value = value;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name;
            switch (name = method.getName()) {
                case "doubleValue": {
                    Unit toUnit = (Unit)args[0];
                    if (toUnit == this.unit || toUnit.equals(this.unit)) {
                        return this.value.doubleValue();
                    }
                    return this.unit.getConverterTo(toUnit).convert(this.value.doubleValue());
                }
                case "longValue": {
                    Unit toUnit = (Unit)args[0];
                    if (toUnit == this.unit || toUnit.equals(this.unit)) {
                        return this.value.longValue();
                    }
                    double doubleValue = this.unit.getConverterTo(toUnit).convert(this.value.doubleValue());
                    if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                        throw new ArithmeticException("Overflow: " + doubleValue + " cannot be represented as a long");
                    }
                    return (long)doubleValue;
                }
                case "getValue": {
                    return this.value;
                }
                case "getUnit": {
                    return this.unit;
                }
                case "toString": {
                    return String.valueOf(this.value) + ' ' + this.unit;
                }
                case "hashCode": {
                    return this.value.hashCode() * 31 + this.unit.hashCode();
                }
                case "equals": {
                    Object obj = args[0];
                    if (!(obj instanceof AbstractQuantity)) {
                        return false;
                    }
                    AbstractQuantity that = (AbstractQuantity)obj;
                    return this.unit.isCompatible((Unit)((AbstractUnit)that.getUnit())) && this.value.doubleValue() == that.doubleValue(this.unit);
                }
                case "compareTo": {
                    AbstractQuantity that = (AbstractQuantity)args[0];
                    return Double.compare(this.value.doubleValue(), that.doubleValue(this.unit));
                }
            }
            throw new UnsupportedOperationException(name);
        }
    }

    private static final class Default<Q extends Quantity<Q>>
    extends ProxyQuantityFactory<Q> {
        private final Class<Q> type;
        private final Unit<Q> metricUnit;
        static final HashMap<Class, Unit> CLASS_TO_METRIC_UNIT = new HashMap();

        Default(Class<Q> type) {
            this.type = type;
            this.metricUnit = CLASS_TO_METRIC_UNIT.get(type);
        }

        @Override
        public Unit<Q> getSystemUnit() {
            return this.metricUnit;
        }

        public Quantity<Q> create(Number value, Unit<Q> unit) {
            return (Quantity)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, new GenericHandler<Q>(value, unit));
        }

        static {
            CLASS_TO_METRIC_UNIT.put(Dimensionless.class, AbstractUnit.ONE);
            CLASS_TO_METRIC_UNIT.put(ElectricCurrent.class, Units.AMPERE);
            CLASS_TO_METRIC_UNIT.put(LuminousIntensity.class, Units.CANDELA);
            CLASS_TO_METRIC_UNIT.put(Temperature.class, Units.KELVIN);
            CLASS_TO_METRIC_UNIT.put(Mass.class, Units.KILOGRAM);
            CLASS_TO_METRIC_UNIT.put(Length.class, Units.METRE);
            CLASS_TO_METRIC_UNIT.put(AmountOfSubstance.class, Units.MOLE);
            CLASS_TO_METRIC_UNIT.put(Time.class, Units.SECOND);
            CLASS_TO_METRIC_UNIT.put(Angle.class, Units.RADIAN);
            CLASS_TO_METRIC_UNIT.put(SolidAngle.class, Units.STERADIAN);
            CLASS_TO_METRIC_UNIT.put(Frequency.class, Units.HERTZ);
            CLASS_TO_METRIC_UNIT.put(Force.class, Units.NEWTON);
            CLASS_TO_METRIC_UNIT.put(Pressure.class, Units.PASCAL);
            CLASS_TO_METRIC_UNIT.put(Energy.class, Units.JOULE);
            CLASS_TO_METRIC_UNIT.put(Power.class, Units.WATT);
            CLASS_TO_METRIC_UNIT.put(ElectricCharge.class, Units.COULOMB);
            CLASS_TO_METRIC_UNIT.put(ElectricPotential.class, Units.VOLT);
            CLASS_TO_METRIC_UNIT.put(ElectricCapacitance.class, Units.FARAD);
            CLASS_TO_METRIC_UNIT.put(ElectricResistance.class, Units.OHM);
            CLASS_TO_METRIC_UNIT.put(ElectricConductance.class, Units.SIEMENS);
            CLASS_TO_METRIC_UNIT.put(MagneticFlux.class, Units.WEBER);
            CLASS_TO_METRIC_UNIT.put(MagneticFluxDensity.class, Units.TESLA);
            CLASS_TO_METRIC_UNIT.put(ElectricInductance.class, Units.HENRY);
            CLASS_TO_METRIC_UNIT.put(LuminousFlux.class, Units.LUMEN);
            CLASS_TO_METRIC_UNIT.put(Illuminance.class, Units.LUX);
            CLASS_TO_METRIC_UNIT.put(Radioactivity.class, Units.BECQUEREL);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseAbsorbed.class, Units.GRAY);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseEffective.class, Units.SIEVERT);
            CLASS_TO_METRIC_UNIT.put(CatalyticActivity.class, Units.KATAL);
            CLASS_TO_METRIC_UNIT.put(Speed.class, Units.METRE_PER_SECOND);
            CLASS_TO_METRIC_UNIT.put(Acceleration.class, Units.METRE_PER_SQUARE_SECOND);
            CLASS_TO_METRIC_UNIT.put(Area.class, Units.SQUARE_METRE);
            CLASS_TO_METRIC_UNIT.put(Volume.class, Units.CUBIC_METRE);
        }
    }
}

