/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.spi;

import java.time.Instant;
import javax.measure.Quantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.spi.Measurement;

abstract class AbstractMeasurement<Q extends Quantity<Q>>
implements Measurement<Q> {
    private static final long serialVersionUID = 2417644773551236879L;
    private final Quantity<Q> quantity;
    private final Instant instant;

    protected AbstractMeasurement(Quantity<Q> q, Instant i) {
        this.quantity = q;
        this.instant = i;
    }

    protected AbstractMeasurement(Quantity<Q> q, long t) {
        this(q, Instant.ofEpochMilli(t));
    }

    protected AbstractMeasurement(Quantity<Q> q) {
        this(q, System.currentTimeMillis());
    }

    public final Quantity<Q> getQuantity() {
        return this.quantity;
    }

    @Override
    public final Instant getInstant() {
        return this.instant;
    }

    @Override
    public final long getTimestamp() {
        return this.instant.toEpochMilli();
    }

    static final class Default<Q>
    extends AbstractMeasurement {
        private static final long serialVersionUID = 823899472806334856L;

        protected Default(Quantity q, Instant i) {
            super(q, i);
        }

        protected Default(Quantity q, long t) {
            super(q, t);
        }

        protected Default(Quantity q) {
            super(q);
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof Measurement) {
                Measurement m = (Measurement)o;
                if (this.getQuantity() instanceof ComparableQuantity) {
                    ComparableQuantity comp = (ComparableQuantity)this.getQuantity();
                    return comp.compareTo(m.getQuantity()) + this.getInstant().compareTo(m.getInstant());
                }
                return 0;
            }
            return 0;
        }
    }
}

